% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{buildMdz}
\alias{buildMdz}
\title{Empiric equation for minimum temperature used in Mendoza}
\usage{
buildMdz(dw, tempMax, tmin)
}
\arguments{
\item{dw}{[°C] Dew Point in °C}

\item{tempMax}{[°C] Maximum temperature of the previous day}

\item{tmin}{[°C] Minimum temperature measure that day.}
}
\value{
an object of class MdzFrostModel
}
\description{
According to Maldonado (see [1]), the empirical equation used in Mendoza
to estimate the minimum
temperature in the night is:

Tmin = ((Tmax + dew)/2)) - K

, where K is a constant calculated for each place,
Tmax: maximum temperature of previous day, dew: dew point
in °C, Tmin: is the forecaste minimum temperature.
Given an array of the information of dw, tempMax and tmin,
this function calculates K constant using linear regression.
[1] Ortiz Maldonado, Alberto. Adversidades agrometeorológicas de Mendoza. 1991.
}
\examples{
# just a random example
dw <- c(-2,-5,2,6,8)
tempMax <- c(10,20,30,25,29)
tmin <- c(-1,-2,3,5,10)
buildMdz(dw,tempMax,tmin)
}
