% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/touch.R
\name{touch}
\alias{touch}
\alias{touch2}
\title{Mock the Unix \command{touch} Utility}
\usage{
touch(...)

touch2(...)
}
\arguments{
\item{...}{Paths to files.}
}
\value{
The Paths to the files touched.
}
\description{
Creating files or ensuring that their file modification times change.

\code{touch2} is an alternate - yet not faster - implementation.
}
\examples{
file1 <- tempfile()
file2 <- tempfile()
touch(file1, file2)
t1 <- file.mtime(file1, file2)
touch(file2)
t2 <- file.mtime(file1, file2)
t1 < t2
file <- file.path(tempfile(), "path", "not", "there.txt")
touch(file)
file.exists(file)
}
\seealso{
Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{split_code_file}()}
}
\concept{file utilities}
