% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{paths}
\alias{paths}
\alias{get_path}
\alias{set_path}
\title{Set or Get the \code{path} Attribute to or from an Object}
\usage{
get_path(x)

set_path(x, path, must_work = TRUE)
}
\arguments{
\item{x}{An object.}

\item{path}{The path to be set.}

\item{must_work}{See \code{\link{normalizePath}}'s argument \code{mustWork}.}
}
\value{
For \code{get_path} the value of \code{attr(x, "path")}.

For \code{set_path} the modified object.
}
\description{
We set paths on some objects, these are convenience wrappers to
\code{\link{attr}}.
}
\examples{
x <- 2
path <- tempfile()
touch(path)
x <- set_path(x, path)
get_path(x)
}
