% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_badge}
\alias{bs_vars_badge}
\title{Bootstrap CSS badge variables}
\usage{
bs_vars_badge(color = NULL, bg = NULL, link_hover_color = NULL,
  active_color = NULL, active_bg = NULL, font_weight = NULL,
  line_height = NULL, border_radius = NULL)
}
\arguments{
\item{color}{Text color.}

\item{bg}{Background color.}

\item{link_hover_color}{Linked badge text color on hover.}

\item{active_color}{Badge text color in active nav link.}

\item{active_bg}{Badge background color in active nav link.}

\item{font_weight}{Font weight, e.g. : \code{"bold"}.}

\item{line_height}{Line height.}

\item{border_radius}{Border radius.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 badge in Bootstrap and Bootswatch themes.
}
\examples{
bs_vars_badge(
  color = "firebrick",
  bg = "steelblue"
)


if (interactive()) {

  library(shiny)

  ui <- fluidPage(
    use_theme(create_theme(
      theme = "default",
      bs_vars_badge(
        color = "yellow",
        bg = "firebrick",
        line_height = 1.2
      )
    )),
    tags$h1("Badges"),
    tags$span(class = "badge", "Simple badge"),
    tags$br(),
    tags$ul(
      class = "list-group",
      tags$li(
        class = "list-group-item",
        "Badge in list group",
        tags$span(class = "badge", "badge")
      ),
      tags$li(
        class = "list-group-item",
        "An other item",
        tags$span(class = "badge", "other")
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)

}
}
