% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timedom.R
\name{timedom}
\alias{timedom}
\title{Defines a linear filter}
\usage{
timedom(A, lags)
}
\arguments{
\item{A}{a vector, matrix or array. If array, the elements \eqn{A[,,k], 1\leq k\leq K}, are real valued \eqn{(d_1\times d_2)} matrices (all of same dimension). If A is a matrix, the \eqn{k}-th row is treated as \eqn{A[,,k]}. Same for the \eqn{k}-th element of a vector. These matrices, vectors or scalars define a linear filter.}

\item{lags}{a vector of increasing integers. It corresponds to the time lags of the filter.}
}
\value{
Returns an object of class \code{timedom}. An object of class  \code{timedom} is a list containing the following components:
\itemize{
\item \code{operators} \eqn{\quad} returns the array \code{A} as given in the argument.
\item \code{lags} \eqn{\quad} returns the vector \code{lags} as given in the argument.
}
}
\description{
Creates an object of class \code{timedom}. This object corresponds to a multivariate linear filter.
}
\details{
This class is used to describe a linear filter, i.e. a sequence of matrices, each of which correspond to a certain lag. Filters can, for example, be used to transform a sequence \eqn{(X_t)} into a new sequence \eqn{(Y_t)} by defining
\deqn{
 Y_t=\sum_k A_kX_{t-k}.
}
See \code{filter.process()}.
Formally we consider a collection \eqn{[A_1,\ldots,A_K]} of complex-valued matrices \eqn{A_k}, all of which have the same dimension \eqn{d_1\times d_2}. Moreover, we consider lags \eqn{\ell_1<\ell_2<\cdots<\ell_K}. The object this function creates corresponds to the mapping \eqn{f: \mathrm{lags}\to \mathbf{R}^{d_1\times d_2}}, where \eqn{\ell_k\mapsto A_k}.
}
\examples{
# In this example we apply the difference operator: Delta X_t= X_t-X_{t-1} to a time series
X = rar(20)
OP = array(0,c(2,2,2))
OP[,,1] = diag(2)
OP[,,2] = -diag(2)
A = timedom(OP, lags = c(0,1))
filter.process(X, A)
}
\seealso{
\code{\link{freqdom}}, \code{\link{is.timedom}}
}
\keyword{classes}
