% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourierin.R
\name{fourierin_1d}
\alias{fourierin_1d}
\title{Univariate Fourier integrals}
\usage{
fourierin_1d(f, a, b, c = NULL, d = NULL, r, s, resol = NULL, w = NULL,
  use_fft = TRUE)
}
\arguments{
\item{f}{function or a vector of size m. If a function is provided,
it must be able to be evaluated in vectors. If a vector of
values is provided, such evaluations must have been obtained on
a regular grid and the Fourier integral is faster is m is a
power of 2.}

\item{a}{Lower integration limit.}

\item{b}{Upper integration limit.}

\item{c}{Lower evaluation limit.}

\item{d}{Upper evaluation limit.}

\item{r}{Factor related to adjust definition of Fourier
transform. It is usually equal to 0, -1 or 1.}

\item{s}{Constant to adjust the exponent on the definition of the
Fourier transform. It is usually equal to 1, -1, 2pi or -2pi.}

\item{resol}{An integer (faster if power of two) determining the
resolution of the evaluation grid. Not required if f is a
vector.}

\item{w}{An optional vector where the Fourier integral will be
evaluated. If provided, the FFT will NOT be used.}

\item{use_fft}{Logical value specifying whether the FFT will be
used to compute the Fourier integral.}
}
\value{
If w is given, only the values of the Fourier integral are
    returned, otherwise, a list with the elements \item{w}{A vector
    of size m where the integral was computed.}  \item{values}{A
    complex vector of size m with the values of the integral}
}
\description{
It computes Fourier integrals of functions of one and two
variables on a regular grid.
}
\details{
See vignette for more detailed examples.
}
\examples{
##--- Example 1 ------------------------------------------------------
##--- Recovering std. normal from its characteristic function --------
library(fourierin)

                                        # Compute integral
out <- fourierin_1d(f = function(t) exp(-t^2/2),
                 a = -5, b = 5, c = -3, d = 3,
                 r = -1, s = -1, resol = 64)
grid <- out$w                           # Extract grid and values
values <- Re(out$values)

plot(grid, values, type = "l", col = 3)
lines(grid, dnorm(grid), col = 4)

##--- Example 2 -----------------------------------------------
##--- Computing characteristic function of a gamma r. v. ------

library(fourierin)
                                        # Compute integral
shape <- 5
rate <- 3
out <- fourierin_1d(f = function(t) dgamma(t, shape, rate),
                 a = 0, b = 6, c = -4, d = 4,
                 r = 1, s = 1, resol = 64)
grid <- out$w                           # Extract grid
re_values <- Re(out$values)             # Real values
im_values <- Im(out$values)             # Imag values

                                        # Now compute the real and
                                        # imaginary true values of the
                                        # characteric function.
true_cf <- function(t, shape, rate) (1 - 1i*t/rate)^-shape
true_re <- Re(true_cf(grid, shape, rate))
true_im <- Im(true_cf(grid, shape, rate))

                                        # Compare them. We can see a
                                        # slight discrepancy on the
                                        # tails, but that is fixed
                                        # when resulution is
                                        # increased.
plot(grid, re_values, type = "l", col = 3)
lines(grid, true_re, col = 4)
                                        # Same here
plot(grid, im_values, type = "l", col = 3)
lines(grid, true_im, col = 4)
}

