% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foto.R
\name{foto}
\alias{foto}
\title{Calculates FOTO classification of texture}
\usage{
foto(x, window_size = 61, method = "zones", plot = FALSE,
  norm_spec = TRUE)
}
\arguments{
\item{x}{an image file, raster layer, stack or brick 
for multilayered images (RGB or otherwise) data are averaged to 
a single layer raster}

\item{window_size}{a moving window size in pixels (default = 61 pixels)}

\item{method}{zones (for discrete zones) or mw for a moving window
approach}

\item{plot}{plot output, bolean \code{TRUE} or \code{FALSE}}

\item{norm_spec}{normalize radial spectrum,
bolean \code{TRUE} or \code{FALSE}}
}
\value{
returns a radial spectrum for a moving window across a
raster layer
}
\description{
Note that the input matrix should be square or results will be discarded
}
\examples{

\donttest{
# load demo data
r <- raster::raster(system.file("extdata", "yangambi.png", package = "foto",
     mustWork = TRUE))

# classify pixels using zones (discrete steps)
output <- foto(r,
               plot = TRUE,
               window_size = 25,
               method = "zones")

# print data structure
print(names(output))
}
}
\seealso{
\code{\link[foto]{rspectrum}}
}
\keyword{foto,}
\keyword{radial}
\keyword{spectrum}
