% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_itp.R
\name{add_itp}
\alias{add_itp}
\title{add_itp}
\usage{
add_itp(x, taxon, legend.pos = "topright")
}
\arguments{
\item{x}{The list output of @seealso threshold_ranges}

\item{taxon}{A character vector of length one, specifying
one of the taxon names in x to be plotted}

\item{legend.pos}{One of topleft, bottomleft, topright or
bottomright, or a vector of length two, giving the xy
coordinates of the legend. A convenience parameter so that
the plot detail can remain unobscured.}
}
\value{
None, the detected peaks are added to an existing density plot
}
\description{
Function to add detected peaks using the output of
}
\examples{
# load dataset
data("brachios")
# subsample brachios to make for a short example runtime
set.seed(1)
brachios <- brachios[sample(1:nrow(brachios), 1000),]
# densify ranges
dens <- densify(brachios)
# interpeak thresholding
itp <- threshold_ranges(brachios, win = 8, thresh = 10,
                        rank = "genus", srt = "max_ma", end = "min_ma")
# append the stratigraphically thresholded taxon names to the dataset
# plot the taxon, now identifying the peaks
plot_dprofile(dens, "Atrypa")
add_itp(itp, "Atrypa")
}
\seealso{
threshold_ranges. This function should be used
to add information to an existing plot from @seealso densify,
ensuring that the same taxon name is being used
}
