% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invert.R
\docType{methods}
\name{invert}
\alias{invert}
\alias{invert,call-method}
\alias{invert,expression-method}
\title{invert}
\usage{
invert(x, ...)

\S4method{invert}{call}(x)

\S4method{invert}{expression}(x)
}
\arguments{
\item{x}{function for invert}

\item{...}{additional arguments passed other functions

\code{invert} is a S4 generic method for inverting relational
operators, i.e. 

functions prefixed with a \code{.} are not exported and should probably not 
be called directly}
}
\value{
The operand is returned with the relational operators inverted.
}
\description{
Invert the operators in an object, usually a formula or expression
}
\examples{
  invert( quote( A >  5 ) )
  invert( quote( A >= 5 ) )
  invert( quote( A <  5 ) )
  invert( quote( A <= 5 ) )
  invert( quote( A == 5 ) )
  invert( quote( A != 5 ) )
  invert( quote( A \%in\% lettters[1:5] ) )
  invert( quote( A \%!in\% letters[1:5] ) )

}
\seealso{
\code{\link{op}}, \code{\link{op.type}}
}
\author{
Christopher Brown
}
