% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DW_Server.R
\name{DW_fetch_state}
\alias{DW_fetch_state}
\title{Fetch Data Wrangling State}
\usage{
DW_fetch_state(
  id,
  input,
  session,
  FM_yaml_file,
  MOD_yaml_file,
  id_UD,
  react_state
)
}
\arguments{
\item{id}{Shiny module ID}

\item{input}{Shiny input variable}

\item{session}{Shiny session variable}

\item{FM_yaml_file}{App configuration file with FM as main section.}

\item{MOD_yaml_file}{Module configuration file with MC as main section.}

\item{id_UD}{ID string for the upload data module used to handle uploads or
the name of the list element in react_state where the data set is stored.}

\item{react_state}{Variable passed to server to allow reaction outside of
module (\code{NULL})}
}
\value{
List containing the current state of the DM module including default
values from the yaml file as well as any changes made by the user. The
structure of the list is defined below.
\itemize{
 \item{yaml:} Contents of the yaml file.
 \item{MC:} Module components of the yaml file.
 \item{DW:} Data wrangling state
 \itemize{
   \item{isgood:} Boolean status of the state. FALSE if the dataset
   identified by id_UD is bad.
   \item{checksum:}         MD5 sum indicating if there was a change in the
   datasets within the view. Use this to trigger updates in respose to
   changes in this module.
   \item{button_counters:}  List of counters to detect button clicks.
   \item{code_previous:}    Loading code from the UD field.
   \item{current_view:}     View id of the current active data wrangling view.
   \item{UD:}               Copy of the \code{"UD"} field of the  \code{id_UD} from the \code{react_state} input.
   \item{ui:}               Current value of form elements in the UI
   \item{ui_hold:}          List of hold elements to disable updates before a full ui referesh is complete.
   \item{view_cntr:}        Counter for tracking view ids, value contains the id of the last view created.
   \item{views:}            List of data wrangling views. Each view has the following structure:
     \itemize{
       \item{checksum:            MD5 sum of WDS}
       \item{code:                Code to generate WDS from start to finish}
       \item{code_dw_only:        Code for just the wrangling portion.}
       \item{code_previous:       Code to load data and assign to view object.}
       \item{elements_table:      Table of data wrangling elements.}
       \item{id:                  Character id (\code{view_idx})}
       \item{idx:                 Numeric id (\code{1})}
       \item{isgood:}             Boolean status of the data view. False if evaluation fails
       \item{key:                 User key (short description)}
       \item{view_ds_object_name: Object name for this data view}
       \item{WDS:                 Current value of the data view with all of the successful commands in elements_table evaluated.}
     }
 }
 \item{MOD_TYPE:} Character data containing the type of module \code{"DW"}
 \item{id:} Character data containing the module id
 \item{FM_yaml_file:} App configuration file with FM as main section.
 \item{MOD_yaml_file:}  Module configuration file with MC as main section.
 module in the session variable.
}
}
\description{
Merges default app options with the changes made in the UI
}
\examples{
# Within shiny both session and input variables will exist,
# this creates examples here for testing purposes:
sess_res = DW_test_mksession(session=list())
session = sess_res$session
input   = sess_res$input

# Configuration files
FM_yaml_file  = system.file(package = "formods", "templates", "formods.yaml")
MOD_yaml_file = system.file(package = "formods", "templates", "DW.yaml")

# We need to specify both the DW module id as well as the
# id of the UD module that feeds into it.
id    = "DW"
id_UD = "UD"

# Creating an empty state object
state = DW_fetch_state(id              = id,
                       input           = input,
                       session         = session,
                       FM_yaml_file    = FM_yaml_file,
                       MOD_yaml_file   = MOD_yaml_file,
                       id_UD           = "UD",
                       react_state     = NULL)

}
