% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{metals}
\alias{metals}
\title{Properties of metals}
\format{
Classes data.table and data.frame:	6 observations of  5 variables:
\describe{
\item{metal}{Character, name of material}
\item{dens}{Numeric, density (kg m\eqn{^{-3}}{^{-3}})}
\item{thrm_exp}{Numeric, coefficient of thermal expansion
(m m\eqn{^{-1}}{^{-1}}K\eqn{^{-1}}{^{-1}})}
\item{thrm_cond}{Numeric, thermal conductivity (W m\eqn{^{-1}}{^{-1}}K\eqn{^{-1}}{^{-1}})}
\item{elast_mod}{Numeric, modulus of elasticity (Pa)}
}
}
\source{
\emph{Marks' Standard Handbook for Mechanical Engineers 9/e} (1987)
E.A. Avallone and T. Baumeister (ed.),
"Basic Properties of Several Metals",
pp. 6-11,  McGraw-Hill, NY.
}
\usage{
data(metals, package = "formatdown")
}
\description{
Table of mechanical and thermal properties of selected metals.
}
\keyword{datasets}
