% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_text.R
\name{insert_text}
\alias{insert_text}
\title{Insert text to forest plot}
\usage{
insert_text(
  plot,
  text,
  row = NULL,
  col = NULL,
  part = c("body", "header"),
  just = c("center", "left", "right"),
  before = TRUE,
  gp = gpar(),
  padding = unit(1, "mm")
)
}
\arguments{
\item{plot}{A forest plot object.}

\item{text}{A character or expression vector, see \code{\link[grid]{textGrob}}.}

\item{row}{Row to insert the text, this will be ignored if the \code{part} is
"header".}

\item{col}{A numeric value or vector indicating the columns the text will be
added. The text will span over the column if a vector is given.}

\item{part}{Part to insert text, body (default) or header.}

\item{just}{The justification of the text, \code{"center"} (default),
\code{"left"} or \code{"right"}.}

\item{before}{Indicating the text will be inserted before or after the row.}

\item{gp}{An object of class \code{"gpar"}, this is the graphical parameter
settings of the text. See \code{\link[grid]{gpar}}.}

\item{padding}{Padding of the text, default is \code{unit(1, "mm")}}
}
\value{
A \code{\link[gtable]{gtable}} object.
}
\description{
This function can be used to insert text to forest plot. Remember to adjust
for the row number if you have added text before, including header. This is
achieved by inserted new row(s) to the plot and will affect the row number.
}
