% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_clutter.R
\name{est_clutter}
\alias{est_clutter}
\title{Estimate future and present basal area, volume, TCA, CMI and MMI values of the Clutter Growth and Yield Model}
\usage{
est_clutter(df, age, basal_area, site, category, coeffs,
  method = "average", output = "table", annual_increment = FALSE)
}
\arguments{
\item{df}{A data frame.}

\item{age}{A numeric vector with the desired age range to be used in the estimation, or a Quoted name for the age variable.}

\item{basal_area}{Quoted name for the basal area variable.}

\item{site}{Quoted name for the average site variable.}

\item{category}{Quoted name for the category variable.}

\item{coeffs}{Numeric vector or a data frame with the fitted values of Clutter's growth and yield model. It must be a named vector, with b0,b1,b2,b3,a0 and a1 as names. a1 is not obligatory.}

\item{method}{Method used for estimating the present basal area of each class. It can either be the class' average basal area \code{"average"}, or an estimated value from a linear quadratic model of site as a function of basal area \code{"model"}. Default: \code{"average"}.}

\item{output}{Type of output the function should return. This can either be \code{"plot"}, for the estimation plots, \code{"table"}, for a data frame with the estimated values, and \code{all} for a list with the plot and 2 more data frames. \code{"table"}.}

\item{annual_increment}{If \code{TRUE}, changes the labels from Mean Monthly Increment (MMI) and Current Monthly Increment (CMI) to Mean Annual Increment (MAI) and Current Annual Increment (CAI). Default \code{FALSE}.}
}
\value{
A data frame, a ggplot object or a list, according to output.
}
\description{
This function estimates the present the present value of basal area for each class
using either the class mean, or a linear quadratic model, and then uses it's value to calculate
the basal area from Clutter's growth and yield model.
}
\examples{

library(forestmangr)
data("exfm17")

head(exfm17)

clutter <- fit_clutter(exfm17, "age", "DH", "B", "V", "S", "plot")
clutter

# Classify data into 3 classes:
ex_class <- classify_site(exfm17, "S", 3, "plot")
head(ex_class ,15)

# Estimate basal area using the average basal area as the initial basal area,
# volume,  Mean Monthly Increment (MMI) and Current Monthly Increment (CMI)
# values using Clutter's model:
est_clutter(ex_class,20:125, "B","S","category_",clutter,"average")

# For a more detailed output, including a plot, use output="all":
est_clutter(ex_class,20:125, "B","S","category_",clutter, output="all")


# Estimate basal area using an estimated basal area as the initial basal area:
est_clutter(ex_class,20:125,"B","S","category_",clutter,"model") 

# age can be a variable:
est_clutter(ex_class,"age","B","S","category_", clutter,"model")  
  
}
\seealso{
other sampling functions: 
  \code{\link{fit_clutter}} for fitting the Clutter Growth and Yield model, and
  \code{\link{classify_site}} for classifying data according to site.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
