% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.forestData}
\alias{plot.forestData}
\title{ForestData Plot}
\usage{
\method{plot}{forestData}(
  x,
  model.type = "H",
  plot.type = "Curve",
  xlab = NA,
  ylab = NA,
  legend.lab = "Site class",
  title = "Oak broadleaf mixed",
  ...
)
}
\arguments{
\item{x}{A data of forestData class.}

\item{model.type}{Type of model used for fitting, options are `H` (tree height model), `BA` (basal area growth model), or `Bio` (stocking growth model).}

\item{plot.type}{Type of plot, options are `Curve` (curve plot), `Scatter_Curve` (scatter plot with curve), `residual` (residual plot), or `Scatter` (scatter plot).}

\item{xlab}{The title for the x axis.}

\item{ylab}{The title for the y axis.}

\item{legend.lab}{The title for the legends.}

\item{title}{The text for the Plot title.}

\item{...}{Additional arguments affecting the figure plotted.}
}
\value{
A trellis plot object
}
\description{
Plot graphs about the forestData.
}
\examples{
\donttest{
# Load sample data
data("forestData")

# Build a model based on the forestData and return a forestData class object
forestData <- class.plot(forestData,model="Richards",
                         interval=5,number=5,
                         a=19,b=0.1,c=0.8)

# Plot the curve of the tree height model
plot(forestData, model.type="H",
     plot.type="Curve",
     xlab="Stand age (year)",ylab="Height (m)",legend.lab="Site class",
     title="Curve of the Oak and Broadleaf Tree Height Model")
}
}
