% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_queue.R
\name{cran_incoming}
\alias{cran_incoming}
\title{List packages in CRAN incoming queue.}
\usage{
cran_incoming(
  pkg = NULL,
  folders = c("newbies", "inspect", "pretest", "recheck", "pending", "publish",
    "archive", "waiting")
)
}
\arguments{
\item{pkg}{Optionally provide a vector of package names to limit the results
to these packages.}

\item{folders}{Which folders of the CRAN queue do you want to inspect? Default:
all the non-human folders.}
}
\value{
A \code{tibble} with the following columns:
\describe{
\item{package}{package name}
\item{version}{package version}
\item{cran_folder}{folder where the package was found}
\item{time}{date/time package was entered in the folder}
\item{size}{the size of the package tarball}
}

Note that if the package version is not provided, it will appear as \code{NA}
in the \code{tibble}.
}
\description{
Check where your package stands in the CRAN incoming queue.
}
\details{
When submitting a package to CRAN, it undergoes a series of checks before it
is published and publicly available. \code{cran_incoming()} allows you to check
the packages that are currently in the queue, and the folder where they are
located. This information could help you track your package submission. Only
the following folders are considered (approximately in order of the CRAN
queue sequence): \code{newbies}, \code{inspect}, \code{pretest}, \code{recheck}, \code{pending},
\code{waiting}, \code{publish}, \code{archive}. The folders named after the initials of the
CRAN volunteers are not inspected.
}
\note{
The meaning of the package folders is as follows
(see Hornik, Ligges and Zeileis \url{https://journal.r-project.org/archive/2018-1/cran.pdf} and Uwe Ligges mailing list comment \url{https://stat.ethz.ch/pipermail/r-package-devel/2019q1/003631.html}):
\describe{
\item{newbies}{for first time submission; package will be manually inspected.}
\item{inspect}{package is awaiting manual inspection; always happens for first time submissions and for packages with problems that are likely to be false positives}
\item{pretest}{a human has triggered a new auto-check of the package}
\item{recheck}{package has passed checks and is waiting for reverse dependency checking}
\item{pending}{a CRAN team member has to do a closer inspection and needs more time}
\item{waiting}{CRAN's decision is waiting for a response from the package maintainer, e.g. when issues are present that CRAN cannot check for in the incoming checks}
\item{publish}{package is awaiting publication}
\item{archive}{package rejected: it does not pass the checks cleanly and the problems are unlikely to be false positives}
}
}
\section{Disclaimer}{

The information provided here is only to give you an indication of where
your package stands in the submission process. It can be useful to confirm
that your package has been correctly uploaded to CRAN. Please consult the
\href{https://cran.r-project.org/web/packages/policies.html}{CRAN Repository Policy} if you have
any questions.
}

\examples{
\dontrun{
  ## all the packages in the CRAN incoming queue
  cran_incoming()
  ## if the package `foo` is in the queue, it will appear below
  cran_incoming(pkg = "foo")
}
}
\references{
\itemize{
\item Hornik, Ligges and Zeileis. "Changes on CRAN: 2017-12-01 to 2018-06-30", R Journal 10(1), July 2018. \url{https://journal.r-project.org/archive/2018-1/cran.pdf}
\item  Maëlle Salmon, Locke Data, Stephanie Locke, Mitchell O'Hara-Wild, Hugo Gruson. "CRAN incoming dashboard", \url{https://lockedata.github.io/cransays/articles/dashboard.html}
}
}
\seealso{
cran_winbuilder
}
