% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcat.R
\name{read.fcat}
\alias{read.fcat}
\title{Read a format catalog from the file system}
\usage{
read.fcat(file_path)
}
\arguments{
\item{file_path}{The path to the format catalog.}
}
\value{
The format catalog as an R object.
}
\description{
The \code{read.fcat} function reads a format catalog
from the file system.  The function accepts a path to the format catalog,
reads the catalog, and returns it.

Note that the format catalog is saved as an RDS file.  The ".fcat" file 
extension only serves to distinguish the format catalog from other RDS
files.
}
\examples{
# Create format catalog
c1 <- fcat(num_fmt  = "\%.1f",
           label_fmt = value(condition(x == "A", "Label A"),
                             condition(x == "B", "Label B"),
                             condition(TRUE, "Other")),
           date_fmt = "\%d\%b\%Y")
           
# Get temp directory
tmp <- tempdir()            
           
# Save catalog to file system
pth <- write.fcat(c1, dir_path = tmp)

# Read from file system
c2 <- read.fcat(pth)

# Use formats in the catalog
fapply(2, c1$num_fmt)
# [1] "2.0"

fapply(c("A", "B", "C", "B"), c1$label_fmt)
# [1] "Label A" "Label B" "Other"   "Label B"

fapply(Sys.Date(), c1$date_fmt)
# [1] "07Jan2024"
}
\seealso{
Other fcat: 
\code{\link{as.data.frame.fcat}()},
\code{\link{as.fcat.data.frame}()},
\code{\link{as.fcat.fmt_lst}()},
\code{\link{as.fcat.list}()},
\code{\link{as.fcat}()},
\code{\link{fcat}()},
\code{\link{is.fcat}()},
\code{\link{print.fcat}()},
\code{\link{write.fcat}()}
}
\concept{fcat}
