% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{condition}
\alias{condition}
\title{Define a condition for a user-defined format}
\usage{
condition(expr, label, order = NULL)
}
\arguments{
\item{expr}{A valid R expression.  The value in the expression is identified
by the variable 'x', i.e.  x == 'A' or x > 3 & x < 6.  The expression 
should not be quoted.}

\item{label}{A label to be assigned if the expression is TRUE.  The label 
can any valid literal value.  Typically, the label will be a character 
string.  However, the label parameter does not restrict the data type.
Meaning, the label could also be a number, date, or other R object type.}

\item{order}{An option integer order number. When used, this parameter 
will effect the order of the labels returned from the 
\code{\link{labels.fmt}} function.  The purpose of the parameter is to control
ordering of the format labels independently of the order they are assigned
in the conditions.  This functionality is useful when you are using the format
labels to assign ordered levels in a factor.}
}
\value{
The new condition object.
}
\description{
The \code{condition} function creates a condition for a user-defined format.
}
\details{
The \code{condition} function creates a condition as part of a format 
definition.  The format is defined using the \code{\link{value}} 
function.  The condition is defined as an expression/label pair.  The 
expression parameter can be any valid R expression.   The label parameter
can be any valid literal.  Conditions are evaluated in the order they 
are assigned.  A default condition is created by assigning the expression
parameter to TRUE.  If your data can contain missing values, it is 
recommended that you test for those values first.

The condition object is an S3 class of type "fmt_cond". The condition 
labels can be extracted from the format using the \code{labels} function.

The format object may be applied to a vector using the \code{fapply}
function.  See \code{link{fapply}} for further details.
}
\examples{
# Set up vector
v1 <- c("A", "B", "C", "B")

# Define format
fmt1 <- value(condition(x == "A", "Label A"),
              condition(x == "B", "Label B"), 
              condition(TRUE, "Other"))
              
# Apply format to vector
v2 <- fapply(v1, fmt1)
v2
}
\seealso{
\code{\link{fdata}} to apply formatting to a data frame,
\code{\link{value}} to define a format,
\code{\link{levels}} or \code{\link{labels.fmt}} to access the labels, and 
\code{\link{fapply}} to apply the format to a vector.
}
