# Functions and data for Japanese population statistics
# written by Minato Nakazawa, 2010.
# rev. 0.2, 24 August 2010
# rev. 0.2.1, 7 May 2011, Vital statistics data for 2010 added in part.
# rev. 0.2.2, 11 December 2011, resting vital statistics data for 2010 added.

# Model population of Japan in Showa 60 (1985)
S60MPJ <- c(8180, 8338, 8497, 8655, 8814, 8972, 9130, 9289, 
 9400, 8651, 7616, 6581, 5546, 4511, 3476, 2441, 1406, 784)*1000

# MortalityJapan Data
# * Japanese age-specific mortality data with age-specific population
# References:
# http://www.stat.go.jp/data/nenkan/02.htm
# http://www.e-stat.go.jp/SG1/estat/List.do?bid=000001025191&amp;cycode=0
# http://www.e-stat.go.jp/SG1/estat/List.do?lid=000001071995 (index for H22 vital statistics)
# http://www.e-stat.go.jp/SG1/estat/Xlsdl.do?sinfid=000008874020 (for H22M and H22F)
# Mortality data of <<Japanese>> in Japan.
# 
JASM <- data.frame(
 AGECLASS = c(paste("[",0:16*5,"-",0:16*5+4,"]",sep=""),"[85-]"), 
 S60MODEL = c(8180, 8338, 8497, 8655, 8814, 8972, 9130, 9289, 9400, 8651, 7616, 6581, 5546, 4511, 3476, 2441, 1406, 784)*1000, 
 S60M = c(6042, 1155, 1011, 3179, 3397, 3167, 4237, 7110, 10234, 15063, 24347, 30747, 30884, 38240, 55100, 65593, 59125, 48786), 
 H02M = c(4532, 844, 760, 3204, 3466, 2916, 3264, 5449, 9769, 14218, 20161, 32925, 42742, 42664, 51737, 69320, 67916, 67451), 
 H07M = c(3929, 752, 716, 2413, 3640, 3203, 3297, 4413, 8236, 15616, 21905, 30491, 47188, 59828, 60927, 68504, 77924, 87750), 
 H12M = c(2933, 438, 493, 1721, 2875, 3271, 3749, 4621, 6840, 13141, 24103, 31848, 42214, 60962, 76413, 73947, 73533, 102177), 
 H17M = c(2291, 409, 361, 1220, 2303, 2887, 3915, 4915, 6806, 10577, 19546, 34233, 43403, 55261, 80198, 99338, 89502, 127261), 
 H22M = c(1703, 240, 321, 867, 1820, 2234, 2920, 4441, 6063, 8663, 13388, 24653, 41726, 52396, 66594, 93095, 108331, 144495), 
 S60F = c(4792, 636, 638, 1033, 1272, 1558, 2496, 4017, 5650, 7644, 11504, 14828, 19961, 26490, 40891, 55657, 64448, 80930), 
 H02F = c(3451, 533, 482, 1149, 1329, 1361, 1774, 3102, 5542, 7510, 10097, 14616, 19986, 27267, 38076, 58203, 71633, 110407), 
 H07F = c(3111, 483, 468, 949, 1447, 1393, 1832, 2426, 4578, 8520, 11041, 14241, 21122, 29261, 41516, 56924, 79939, 141519), 
 H12F = c(2336, 300, 251, 676, 1160, 1546, 1847, 2425, 3639, 6595, 11740, 14144, 18466, 28096, 40115, 57053, 73527, 171735), 
 H17F = c(1811, 246, 229, 582, 1067, 1283, 2037, 2554, 3432, 5177, 9418, 15346, 18855, 25568, 40627, 60024, 84683, 225778), 
 H22F = c(1381, 190, 191, 442, 713, 953, 1514, 2460, 3209, 4511, 6720, 11162, 18111, 23276, 33466, 54783, 82815, 264402), 
 S60MP = c(3818777, 4373058, 5146970, 4600427, 4165995, 3948330, 4558265, 5398230, 4551877, 4092121, 3926414, 3409374, 2379902, 1781008, 1503595, 1017428, 542243, 255975),
 H02MP= c(3326039, 3821833, 4369880, 5122215, 4468199, 4078469, 3925353, 4524829, 5349985, 4482298, 3997248, 3783367, 3236549, 2194783, 1559972, 1197457, 678385, 357040),
 H07MP = c(3070015, 3349827, 3826968, 4385775, 5041228, 4452125, 4113849, 3945809, 4527352, 5328335, 4421787, 3906621, 3611948, 2998706, 1941558, 1260411, 824492, 479086),
 H12MP = c(3022521, 3083431, 3353150, 3833984, 4307242, 4965277, 4436818, 4096286, 3924171, 4467772, 5210038, 4290239, 3749528, 3357281, 2670270, 1625822, 915268, 653475),
 H17MP = c(2854502, 3036503, 3080678, 3373430, 3754822, 4198551, 4933265, 4402787, 4065470, 3867500, 4383240, 5077369, 4154529, 3545006, 3039743, 2256317, 1222635, 810898),
 H22MP = c(2710581, 2859805, 3031943, 3109229, 3266240, 3691723, 4221011, 4950122, 4400375, 4027969, 3809576, 4287489, 4920468, 3921774, 3225503, 2582940, 1692584, 1047611),
 S60FP = c(3640486, 4158776, 4895151, 4379520, 4034559, 3875072, 4495959, 5339814, 4583077, 4144493, 4006580, 3590371, 3025636, 2412411, 2059802, 1475915, 890694, 529272),
 H02FP = c(3166858, 3644724, 4156905, 4884872, 4331922, 3992244, 3862332, 4478951, 5308305, 4535714, 4091138, 3941521, 3508465, 2908793, 2257562, 1820756, 1154473, 765374),
 H07FP = c(2925239, 3190844, 3650837, 4172183, 4853773, 4336016, 4012606, 3876412, 4478720, 5290031, 4500131, 4046859, 3863161, 3397372, 2753609, 2028656, 1476273, 1100659),
 H12FP = c(2881577, 2938358, 3193462, 3654181, 4114218, 4825032, 4339792, 4018579, 3876048, 4448236, 5231952, 4443933, 3986305, 3748658, 3230306, 2524778, 1699421, 1579873),
 H17FP = c(2723585, 2891992, 2933974, 3194950, 3595776, 4081498, 4821592, 4332994, 4015126, 3858361, 4413259, 5177795, 4390100, 3887604, 3597754, 3006484, 2189758, 2115806),
 H22FP = c(2586167, 2725856, 2889092, 2954128, 3160193, 3601978, 4120486, 4836227, 4341490, 4005147, 3834923, 4376245, 5116781, 4288399, 3737799, 3358073, 2643680, 2747322)
)

# Age structures of Japan from 1888 to 2010
Jpop <- data.frame(
 Age = c(sprintf("%d",0:84),"85+"),
 M1888 = c(539962, 469536, 470197, 449086, 443053, 458304, 450499, 454853, 440727, 444884, 441802, 429857, 445958, 412208, 402551, 400626, 354671, 328631, 318501, 320255, 367315, 332457, 326722, 353824, 337183, 286454, 267747, 248681, 284076, 282911, 307536, 304933, 295960, 292081, 300346, 293079, 298184, 254272, 269215, 288596, 274011, 260447, 242722, 251201, 236685, 241090, 209308, 215382, 202426, 186624, 171901, 142281, 169829, 169811, 157469, 156079, 169846, 152641, 166130, 140839, 141986, 136525, 122316, 124440, 115478, 104853, 106483, 86080, 84246, 82064, 69670, 59619, 57921, 49142, 44238, 41984, 34636, 32570, 25655, 20675, 19302, 15535, 12449, 10829, 8341, 15116),
 F1888 = c(520477, 456728, 464484, 437816, 436275, 452806, 440192, 449820, 431196, 436490, 430249, 416833, 436860, 402193, 393830, 390332, 343913, 318685, 309364, 312341, 353366, 324587, 314969, 341210, 325249, 279142, 260291, 243576, 272548, 277030, 291097, 293245, 283190, 278231, 282355, 276216, 277217, 241261, 250557, 271006, 252869, 248619, 202031, 242039, 220613, 223010, 195498, 199379, 190087, 174937, 162685, 139618, 163277, 165918, 153014, 157093, 168845, 152207, 161576, 143623, 147307, 140389, 127731, 131105, 123072, 113425, 113211, 97254, 95246, 92907, 79595, 72185, 70452, 61542, 55903, 54271, 46616, 44037, 35214, 30470, 28239, 23855, 19564, 17354, 13497, 28919),
 M1893 = c(531884, 513295, 450066, 469437, 493529, 479868, 439925, 450351, 435507, 435302, 452498, 445389, 450400, 437540, 441487, 436830, 422396, 439676, 405094, 393641, 389073, 343620, 317886, 304964, 306768, 352743, 318411, 313469, 340083, 323864, 274532, 256060, 237639, 271387, 269131, 293987, 292457, 281992, 278821, 285916, 276905, 281637, 239655, 252098, 271199, 256147, 242090, 224229, 232286, 217095, 220575, 189748, 194073, 182214, 166659, 152201, 123033, 147627, 146318, 132928, 131473, 141716, 125394, 134802, 111637, 110911, 105788, 92241, 92559, 83626, 73350, 72816, 57037, 53939, 50629, 41589, 33400, 31345, 25499, 21596, 19251, 14999, 13250, 9810, 7262, 23411),
 F1893 = c(514991, 496325, 439461, 456309, 481878, 465354, 429037, 444884, 426928, 427514, 448257, 435490, 446481, 428566, 431449, 425001, 409843, 430262, 395188, 384955, 380341, 332723, 308511, 295267, 298801, 340030, 308992, 300281, 325505, 310628, 264545, 246640, 228807, 257809, 261284, 275144, 276314, 266833, 262420, 266216, 259082, 259851, 225665, 235273, 254253, 236742, 233660, 187499, 226921, 205771, 208324, 180272, 184421, 174648, 159099, 147771, 124527, 146364, 148255, 134189, 138032, 147163, 131302, 137866, 120419, 121922, 114831, 102381, 104250, 95173, 85353, 83798, 69642, 65784, 62702, 51926, 44155, 42105, 35233, 30165, 27863, 22531, 20097, 15134, 12254, 40897),
 M1898 = c(610181, 566578, 528074, 517467, 501655, 477716, 479135, 429067, 455998, 484852, 474595, 434128, 444642, 430407, 430185, 447303, 439833, 443536, 428980, 431504, 426227, 411754, 426814, 389848, 376914, 374171, 327661, 304114, 291981, 293383, 339995, 306348, 299073, 327382, 310989, 261791, 242355, 224144, 258210, 256376, 280548, 278364, 267512, 263866, 269469, 261455, 265605, 222129, 234035, 251991, 236531, 222624, 203763, 210858, 194960, 197579, 167547, 170646, 158749, 143012, 129182, 102204, 122084, 119564, 106861, 103793, 110537, 95486, 100971, 81161, 79268, 73315, 61718, 60466, 52855, 44452, 42542, 31575, 29128, 26056, 20238, 14656, 12992, 10074, 8060, 26662),
 F1898 = c(599251, 549702, 521339, 503210, 485609, 466586, 466875, 422199, 444950, 475109, 461107, 423598, 438998, 421034, 422676, 441201, 429114, 439147, 419572, 421525, 415300, 398323, 418838, 381668, 371662, 367081, 319343, 294618, 282975, 285071, 325182, 296682, 285809, 312337, 297486, 250877, 232302, 214233, 243422, 247516, 260100, 261115, 252430, 246514, 250306, 245481, 245790, 211723, 219948, 240104, 221636, 219637, 171766, 211085, 189132, 191570, 163566, 166784, 157738, 142062, 130436, 108304, 127503, 127296, 114062, 115837, 121890, 106750, 110123, 93834, 94037, 86287, 74977, 74754, 65780, 57034, 53703, 42789, 38872, 36021, 28063, 22138, 19810, 15788, 12763, 47445),
 M1903 = c(664315, 638514, 616396, 572519, 549855, 550031, 531195, 506818, 504418, 492810, 471597, 474410, 425324, 450108, 480285, 468622, 426026, 434786, 419418, 417953, 435392, 429125, 431056, 415809, 417046, 412211, 397700, 413026, 377825, 364985, 362590, 317693, 294485, 282647, 283627, 327134, 294012, 287552, 314248, 297143, 250808, 232242, 213672, 245604, 244039, 265958, 262832, 251498, 247694, 251072, 242082, 245527, 204086, 213565, 228408, 212567, 199353, 180915, 185673, 169604, 170541, 142833, 143345, 132467, 117433, 104241, 81006, 94826, 91043, 79619, 75823, 78399, 65846, 67362, 51928, 49349, 43808, 35387, 33276, 28109, 22242, 20457, 14442, 13011, 11093, 33850),
 F1903 = c(641621, 620169, 598610, 554751, 530308, 542691, 517561, 500445, 490512, 477739, 460600, 461780, 417257, 437744, 467626, 452501, 413826, 428143, 410684, 410904, 430581, 416397, 424390, 404430, 406125, 400326, 382963, 401335, 365926, 355907, 351889, 305561, 282075, 271009, 273007, 310584, 281498, 272063, 296924, 281927, 237663, 220461, 202600, 230543, 234701, 246534, 247121, 238250, 233530, 236057, 230296, 229738, 197427, 204384, 222366, 204478, 201206, 157111, 192085, 170697, 170789, 144266, 146194, 136647, 122794, 110978, 90288, 105002, 102912, 90361, 90416, 93022, 79508, 79283, 64892, 63226, 56301, 46625, 45089, 37629, 30911, 27788, 21179, 18233, 16173, 52144),
 M1908 = c(742391, 673382, 587905, 583248, 578223, 591956, 598996, 592778, 558654, 539602, 544954, 525538, 500815, 498141, 487321, 465002, 466238, 416217, 438568, 465970, 454330, 412210, 419455, 402978, 400512, 404516, 401608, 408120, 394006, 395430, 391800, 378613, 393634, 361857, 349383, 346608, 303931, 281517, 270734, 271096, 312018, 280457, 274232, 296665, 281710, 237380, 218815, 201269, 229670, 227367, 247482, 242859, 231203, 226987, 228191, 218960, 219618, 181647, 188315, 199504, 184244, 169803, 152651, 155034, 139931, 137510, 112975, 111611, 100957, 87608, 75963, 57779, 65018, 60626, 51855, 47814, 47358, 38543, 37601, 27602, 25123, 21030, 16771, 14956, 12190, 49540),
 F1908 = c(720300, 666180, 550532, 578260, 561647, 574544, 581553, 575561, 540613, 519425, 539245, 511929, 493264, 482125, 469579, 450164, 449176, 405882, 423953, 451233, 437288, 400732, 413653, 395379, 395092, 411871, 397509, 403584, 384963, 386657, 380999, 364322, 381713, 347760, 338046, 333097, 290358, 267536, 257473, 258400, 292993, 266995, 257832, 279256, 265880, 224722, 208515, 191570, 216851, 219811, 231834, 231682, 222359, 217086, 218561, 212255, 210658, 180395, 185126, 199520, 182565, 178010, 138642, 166852, 146539, 144206, 120192, 120371, 110608, 97681, 86090, 68386, 77152, 74053, 63029, 61101, 60464, 49657, 47457, 36703, 33930, 28769, 22581, 20837, 16384, 63740),
 M1913 = c(793494, 735634, 717503, 682483, 670039, 658098, 633390, 566780, 570109, 569974, 586399, 594110, 586211, 550558, 532460, 537297, 516743, 491169, 486451, 473514, 449780, 449660, 401304, 422445, 449450, 439346, 397652, 405621, 389542, 385501, 390809, 387813, 393500, 379434, 380017, 376196, 363728, 378330, 348153, 335007, 332367, 290604, 268962, 257606, 258019, 295755, 264607, 258705, 278554, 264017, 221157, 203110, 185763, 211839, 207744, 224348, 218949, 206807, 201615, 200652, 189930, 189593, 153739, 158212, 164662, 150144, 136303, 120994, 120262, 106055, 101374, 81318, 78626, 69276, 57948, 48547, 35846, 39061, 35168, 28744, 26229, 24888, 19606, 18237, 12667, 68466),
 F1913 = c(769695, 716247, 702610, 672180, 656631, 640464, 627574, 532811, 566653, 553011, 569559, 577440, 569362, 531701, 510086, 527254, 498916, 478680, 467651, 454169, 434937, 433156, 390794, 407231, 433611, 419604, 383777, 394543, 377543, 375935, 392171, 379072, 386417, 368519, 368012, 363093, 346644, 363272, 330342, 321162, 317477, 275386, 254239, 243306, 245232, 277755, 253052, 243930, 264524, 251790, 211595, 195895, 179648, 203019, 205168, 214483, 213604, 204024, 198240, 197889, 190627, 187849, 159409, 162961, 172888, 156425, 150287, 115548, 136986, 118900, 114015, 92887, 90776, 81444, 69633, 59921, 45724, 49950, 46199, 37667, 35105, 33440, 26279, 23548, 17122, 78853),
 M1918 = c(780605, 745709, 727338, 720168, 723232, 701273, 691781, 692262, 666249, 658101, 649356, 626106, 558722, 561275, 560219, 575350, 581830, 571252, 532139, 513168, 514331, 493208, 468751, 463445, 451509, 429658, 429793, 384342, 403590, 429508, 418359, 379102, 385438, 370727, 366842, 371949, 368999, 373983, 360047, 360700, 357379, 343813, 357291, 328833, 317019, 313216, 272834, 251592, 240740, 239545, 274216, 243179, 236695, 253168, 238687, 198759, 182346, 164187, 185875, 181414, 193347, 186564, 174432, 167099, 164671, 152544, 149365, 118767, 120137, 122353, 108420, 96370, 83020, 80173, 67966, 63408, 48686, 45405, 38374, 30904, 24814, 17540, 18189, 15698, 12571, 82029),
 F1918 = c(764984, 732717, 709952, 705082, 699962, 681580, 675349, 678332, 655533, 646179, 633498, 621382, 524570, 556724, 541154, 556054, 559869, 549900, 511205, 489393, 505218, 477538, 457409, 446290, 432055, 412207, 411432, 368963, 384448, 410631, 395151, 360830, 372804, 356239, 356005, 370056, 357991, 364558, 347260, 346600, 342340, 325619, 342441, 311377, 303320, 300262, 259910, 239383, 229344, 230495, 260349, 235633, 227288, 245020, 232404, 194576, 179948, 163658, 184442, 185171, 191290, 189534, 179162, 172709, 170688, 162077, 157706, 131400, 132159, 138455, 121595, 115202, 85947, 99086, 83496, 77283, 60486, 57069, 49692, 40761, 32904, 23788, 24498, 21490, 16551, 86166),
 M1920 = c(945066, 699760, 696705, 700319, 710777, 693097, 710875, 699984, 696316, 666884, 647926, 652832, 633372, 611589, 543506, 548173, 542611, 562069, 553269, 542900, 507656, 454593, 464661, 448240, 441329, 437897, 417268, 397286, 397149, 358405, 378262, 393733, 377506, 359513, 324429, 340166, 343045, 339568, 338880, 346112, 324853, 338875, 330215, 317831, 328480, 294835, 284428, 275922, 255836, 229383, 212305, 224716, 255192, 216904, 213123, 228975, 212156, 166609, 157988, 146357, 165791, 160960, 163556, 163247, 149479, 142279, 137592, 122325, 116785, 95498, 94922, 94613, 82342, 66461, 61202, 55700, 45758, 39810, 29684, 27301, 21243, 16310, 11705, 8384, 7831, 24696),
 F1920 = c(932477, 693228, 690980, 691180, 697223, 679831, 693058, 682137, 681472, 653266, 634949, 636603, 617284, 597638, 525868, 533853, 526648, 545539, 539377, 524618, 495101, 461315, 473562, 434769, 428084, 416528, 397665, 378191, 378746, 344814, 361079, 379946, 363827, 352664, 318491, 334543, 342127, 342228, 337205, 346864, 319173, 332044, 319390, 311378, 321525, 289040, 280639, 273052, 250014, 225418, 209189, 223561, 254180, 212973, 212619, 230339, 211913, 168543, 163254, 153959, 171594, 169595, 172080, 175390, 164113, 156562, 154181, 139986, 133431, 113898, 114704, 117484, 103348, 86085, 75457, 76830, 64926, 57007, 43478, 41518, 33100, 26129, 19991, 15087, 14403, 51310),
 M1925 = c(965811, 831914, 803695, 794814, 764245, 806161, 655769, 665422, 675149, 688670, 676678, 699259, 694727, 687458, 652869, 633577, 636543, 609350, 589150, 519750, 522162, 502399, 518298, 519397, 512543, 482679, 452759, 462125, 434361, 424578, 417464, 397434, 378762, 382464, 344053, 365381, 379399, 364073, 346726, 312959, 324028, 326691, 322112, 321718, 329675, 309872, 317391, 310093, 297059, 305073, 272310, 261141, 251696, 232766, 205918, 190699, 199658, 224394, 184650, 181834, 194160, 177170, 137565, 128490, 116615, 128737, 123199, 121786, 119078, 108675, 100029, 93510, 79281, 73141, 57594, 55868, 52431, 43854, 32846, 28633, 24618, 19172, 15517, 10838, 8951, 21546),
 F1925 = c(954913, 819843, 793732, 785363, 750253, 793330, 647753, 658139, 661830, 672209, 660136, 677890, 674824, 672300, 638889, 619866, 624931, 591961, 568664, 491485, 506919, 486014, 506967, 500042, 485786, 462179, 427746, 438005, 405613, 403426, 388669, 368073, 354379, 360271, 324518, 343788, 360040, 341824, 331931, 303256, 313581, 319763, 319798, 317931, 326468, 304428, 312920, 302295, 293418, 302600, 271015, 260618, 253943, 233785, 207711, 194281, 206614, 233502, 186369, 188816, 204394, 188031, 149411, 142108, 130397, 142527, 139828, 139712, 139369, 131429, 122693, 117495, 101916, 94972, 78549, 77296, 75283, 64239, 50279, 42285, 40313, 32898, 26929, 19619, 16979, 47149),
 M1930 = c(985978, 906284, 882064, 892926, 876190, 818268, 787488, 791425, 770332, 747273, 787708, 638012, 657616, 668724, 684500, 670377, 687032, 670302, 659262, 631690, 607136, 593436, 568102, 557128, 489604, 497517, 487241, 503125, 501079, 491795, 461605, 437622, 446004, 420519, 409290, 404573, 384820, 366631, 368993, 331888, 349878, 364120, 346957, 331246, 295733, 307629, 307067, 303068, 301051, 306342, 285734, 293312, 284354, 271418, 275758, 245697, 233846, 222549, 204467, 179307, 163068, 169057, 185901, 154599, 147690, 154147, 138420, 104624, 95339, 84663, 92270, 84643, 82477, 77549, 67045, 59727, 53644, 43390, 37777, 27913, 25506, 23199, 17912, 12443, 10123, 25937),
 F1930 = c(966328, 892847, 867421, 880805, 860292, 807296, 775957, 779521, 758222, 731303, 770273, 628181, 645661, 653383, 666987, 652238, 663652, 650111, 642497, 612443, 585975, 588191, 554187, 532306, 455441, 481256, 461284, 477735, 474166, 460436, 433927, 407310, 422269, 390638, 384481, 374775, 356739, 340407, 344027, 311980, 327957, 343896, 324108, 317016, 285567, 298941, 304450, 305593, 302769, 309353, 284874, 295217, 283176, 276145, 280706, 252169, 242153, 233671, 213050, 189194, 174953, 185281, 206472, 169157, 165907, 175759, 158848, 123350, 115800, 104880, 112530, 107418, 106474, 102993, 93202, 85101, 77557, 64907, 56836, 44866, 42701, 40156, 31952, 23403, 18066, 58328),
 M1935 = c(1031081, 933210, 931018, 918975, 899717, 870382, 858901, 852881, 867527, 853572, 814735, 776991, 780365, 763582, 741101, 776367, 631960, 643259, 645384, 653743, 630192, 608136, 598567, 610643, 589245, 567214, 564031, 542553, 528353, 468097, 474670, 464869, 482303, 483147, 474503, 446621, 419209, 430075, 404539, 393002, 385265, 367706, 349124, 350381, 315151, 333627, 343211, 326956, 311132, 276253, 286472, 284261, 279110, 276434, 278099, 258825, 261471, 252886, 240876, 241034, 212209, 199776, 188486, 170284, 146065, 131019, 132742, 142070, 115109, 109068, 110507, 96532, 71173, 62607, 53404, 55992, 48828, 45601, 40761, 33647, 28435, 24048, 17970, 14700, 9890, 30216),
 F1935 = c(1004828, 913346, 914236, 899666, 882424, 853965, 846563, 837284, 854297, 836047, 802531, 763111, 766684, 752045, 724102, 758172, 620520, 632900, 635965, 642647, 622918, 627180, 607156, 601809, 575225, 554063, 553608, 523005, 503334, 435825, 458296, 437229, 458719, 457304, 441597, 420085, 387726, 402106, 372748, 369735, 355587, 337520, 322809, 327249, 295219, 314479, 325566, 308594, 300453, 272563, 282637, 287075, 287670, 283654, 287463, 266675, 272572, 262554, 255385, 258859, 229314, 218558, 210730, 190033, 165156, 151793, 158558, 172354, 137896, 136483, 139792, 123864, 94104, 86295, 75145, 78599, 72003, 68437, 62967, 54969, 48041, 41735, 32357, 27393, 19410, 68445),
 M1940 = c(1014500, 848400, 894300, 926900, 939400, 909100, 887400, 897200, 890700, 881700, 855600, 844300, 848700, 850500, 844700, 800600, 752700, 739600, 705900, 671900, 651100, 347800, 366400, 435100, 499200, 497600, 517600, 515700, 527100, 521300, 512800, 514000, 495600, 487500, 435300, 445800, 437200, 454500, 457200, 446200, 420200, 396400, 405100, 380100, 366800, 361000, 341500, 324800, 326100, 291600, 308200, 317500, 298000, 281700, 248800, 257800, 252100, 246000, 243000, 241400, 222100, 223300, 211700, 197500, 194600, 168100, 155100, 144300, 127800, 107200, 92800, 91800, 95700, 74000, 67000, 65300, 54600, 38300, 31800, 26000, 25300, 20700, 18300, 15000, 11300, 31000),
 F1940 = c(985900, 827400, 876600, 905900, 915800, 887500, 870800, 879800, 870200, 863900, 836200, 830300, 832800, 836200, 830200, 792100, 749700, 745900, 720400, 684800, 712700, 575400, 582300, 584500, 591600, 570600, 578700, 563300, 562700, 541500, 522300, 524400, 497500, 480500, 416100, 439600, 421500, 438700, 439100, 423800, 399400, 372000, 383300, 354100, 348900, 338800, 320900, 306700, 311200, 280300, 298400, 309300, 289500, 280800, 252800, 264200, 265200, 264300, 261700, 263400, 243200, 248500, 236200, 226200, 224300, 198200, 185600, 177200, 157400, 134300, 119900, 124200, 132300, 100900, 96500, 95400, 81300, 59500, 51300, 42900, 42100, 36500, 32800, 28800, 23400, 72100),
 M1947 = c(1274050, 790690, 832073, 1014303, 986990, 1018877, 1002728, 909484, 806104, 860213, 906820, 917676, 887522, 859262, 878009, 871785, 861470, 826178, 806677, 778462, 779465, 743288, 688986, 610123, 540594, 508479, 484361, 512924, 445542, 459607, 470024, 482991, 470148, 486143, 471381, 466790, 472637, 469089, 466941, 454102, 456157, 409642, 415118, 405748, 423943, 422027, 415649, 392223, 365972, 368340, 344634, 333510, 329871, 305111, 286598, 286283, 251255, 263202, 268968, 247231, 231169, 195657, 197791, 191450, 180468, 170739, 169437, 147842, 143427, 133004, 118617, 114975, 94711, 83231, 73692, 61440, 47569, 38139, 33520, 32385, 23383, 19968, 17556, 13490, 8045, 23224),
 F1947 = c(1223585, 764614, 815766, 994016, 965559, 992351, 982155, 893018, 790419, 843666, 883612, 902634, 872165, 843647, 861346, 856647, 844888, 815334, 808991, 793425, 777400, 771206, 754115, 705445, 691282, 671789, 641299, 664592, 545282, 557759, 557950, 562947, 551175, 560080, 534760, 533357, 529332, 509506, 500683, 479346, 460245, 396238, 413444, 396635, 414828, 409998, 399021, 380110, 350746, 354759, 325100, 319116, 313280, 295745, 279014, 279999, 249248, 267723, 272907, 257643, 243002, 213161, 219496, 222125, 215026, 206801, 206889, 184884, 182370, 174115, 157148, 155074, 133393, 119543, 109762, 92055, 73129, 61554, 55262, 55192, 40688, 37576, 34162, 26324, 17285, 53116),
 M1950 = c(1182171, 1286543, 1264541, 1198969, 786266, 831695, 1008498, 978246, 1007452, 999535, 910239, 799903, 863405, 906746, 920094, 884422, 860642, 869344, 861541, 841618, 802744, 783719, 764479, 752413, 732460, 674941, 609884, 543701, 507376, 485996, 517749, 437635, 456249, 465986, 482621, 473869, 488768, 474335, 476776, 462357, 458889, 458870, 446234, 444655, 390307, 404955, 393991, 412372, 409830, 397700, 372487, 346338, 353080, 330302, 317068, 307578, 288699, 271109, 272106, 239169, 248485, 246402, 228624, 209036, 177020, 177794, 168497, 158173, 149451, 142004, 125348, 120299, 109434, 96685, 88525, 72140, 62677, 54100, 44756, 34017, 26469, 23524, 20963, 13666, 10967, 28757),
 F1950 = c(1133819, 1236138, 1215447, 1148008, 753555, 808775, 982049, 955372, 979916, 971127, 887460, 781549, 848275, 885510, 896736, 866860, 844560, 855154, 848454, 835073, 800066, 790078, 774428, 765699, 759456, 727321, 686462, 673201, 651224, 625014, 653342, 532345, 546574, 550679, 559057, 541528, 552877, 531098, 535982, 510483, 491979, 490953, 465168, 453861, 382064, 407549, 385431, 405239, 401411, 386071, 364235, 331761, 343496, 318152, 311749, 301155, 283405, 267119, 273923, 244766, 260938, 260369, 240866, 230650, 201505, 206601, 202278, 197282, 188857, 179778, 163941, 161441, 150459, 138053, 127423, 107661, 96444, 85746, 72289, 55823, 46806, 43641, 40695, 26592, 22460, 66651),
 M1955 = c(875952, 874643, 927800, 989687, 1058248, 1144964, 1264782, 1257152, 1192780, 776813, 827056, 1003333, 977202, 1011047, 997162, 906578, 796136, 852872, 888736, 897047, 864749, 833829, 843018, 835105, 819714, 784388, 771468, 757398, 739378, 722750, 672348, 605186, 536980, 503550, 479175, 510722, 431127, 447980, 457391, 472278, 464994, 477632, 464012, 464696, 453416, 450264, 445379, 431780, 430697, 377395, 389533, 379789, 394440, 388306, 377181, 353605, 325323, 327958, 308274, 292543, 281414, 261359, 242841, 235674, 205505, 211002, 207775, 188576, 170247, 141456, 139047, 129376, 118199, 107724, 99430, 84967, 78857, 68991, 58111, 51133, 39521, 32319, 26317, 20588, 14447, 39681),
 F1955 = c(833387, 835448, 889975, 949493, 1013108, 1097602, 1214277, 1206274, 1142290, 745658, 805159, 978037, 954724, 985160, 968937, 887541, 782821, 843394, 878730, 891664, 863515, 835295, 848784, 836318, 822916, 788115, 780090, 763514, 749301, 747926, 719225, 677884, 662741, 643241, 616602, 644338, 524465, 537394, 541267, 548164, 530923, 541183, 520495, 525272, 502707, 485022, 478224, 451199, 442745, 374468, 395924, 374663, 392135, 386276, 371243, 350441, 317696, 326864, 306571, 296239, 284924, 266127, 250625, 248812, 219312, 232794, 231430, 210004, 200872, 172863, 175188, 169307, 162405, 150863, 141123, 125293, 120059, 107518, 95603, 85169, 68426, 58167, 49463, 39696, 28843, 94441),
 M1960 = c(819570, 828314, 804114, 785371, 836380, 887769, 884000, 937370, 995634, 1065805, 1154276, 1273695, 1266718, 1207759, 775461, 816862, 991000, 958960, 986034, 960998, 871111, 761657, 815279, 848971, 863078, 840007, 812566, 831572, 828594, 816427, 784994, 772624, 759057, 736485, 720880, 671027, 601413, 533583, 500665, 476182, 507042, 425861, 441900, 451411, 464906, 456709, 467180, 454380, 453287, 440403, 435822, 431446, 415031, 412210, 359228, 368792, 358168, 369692, 365575, 351144, 325500, 296527, 295668, 272307, 256755, 244168, 224260, 204214, 195377, 167023, 167498, 162400, 143430, 124855, 100489, 95354, 85584, 75661, 65391, 57777, 46721, 41287, 33765, 26973, 21853, 57103),
 F1960 = c(780378, 790690, 769550, 751134, 799327, 847453, 843533, 901999, 955303, 1020275, 1108179, 1224304, 1217132, 1158394, 744272, 800488, 977690, 947775, 978402, 961464, 879897, 773781, 834811, 865851, 876546, 849916, 821439, 838591, 825909, 814503, 781237, 773388, 759337, 744784, 742907, 716565, 673435, 657853, 639031, 613381, 639372, 518977, 530895, 535514, 542069, 524112, 533009, 513896, 516045, 491792, 474437, 469649, 440134, 429741, 363506, 382320, 361759, 377507, 374443, 357976, 336354, 302862, 307906, 284361, 274768, 261327, 242277, 225825, 220994, 193825, 202058, 198605, 176523, 163809, 137360, 135970, 127558, 118474, 105931, 95697, 81309, 74375, 63405, 53046, 44929, 133500),
 M1965 = c(900258, 857136, 833855, 810592, 802931, 810541, 826881, 805554, 782201, 831017, 877404, 875746, 933850, 992880, 1058445, 1140306, 1250399, 1234606, 1166953, 735091, 776412, 941244, 917413, 949076, 939824, 864534, 761580, 824717, 861327, 879403, 851704, 826279, 843032, 837513, 822441, 790396, 776690, 758470, 734333, 713583, 665282, 595806, 528489, 495006, 464059, 496875, 417432, 432834, 440414, 453185, 443878, 452593, 436822, 434134, 420060, 414837, 405715, 393084, 393540, 335367, 340750, 327245, 334858, 324182, 308011, 283822, 255103, 251075, 227080, 209661, 196605, 175924, 156823, 145256, 120764, 117842, 109462, 92775, 76561, 58771, 52601, 44405, 37191, 29775, 24778, 74765),
 F1965 = c(863267, 822556, 801608, 778511, 770893, 780671, 796870, 779095, 756188, 801102, 844291, 843687, 906481, 961297, 1023422, 1109921, 1224596, 1210642, 1145897, 729585, 785845, 959637, 935590, 967320, 955158, 879402, 775033, 840204, 869815, 879212, 846514, 822887, 838551, 824090, 811906, 780125, 771469, 754836, 739687, 734408, 707710, 667483, 651481, 631643, 598062, 628341, 510736, 522288, 525205, 532022, 513849, 520729, 499734, 497462, 472210, 457390, 445862, 420642, 416419, 347278, 363217, 340689, 355358, 345318, 329000, 308739, 274822, 276223, 253338, 241603, 227916, 208560, 190717, 182015, 156038, 159576, 151609, 129793, 116481, 93267, 87916, 78762, 69665, 58881, 49940, 178714),
 M1970 = c(974495, 965677, 942789, 943929, 738025, 915097, 859064, 836183, 811055, 804504, 814215, 827301, 808216, 786420, 830419, 870185, 866940, 914803, 959808, 1011137, 1092090, 1195607, 1195607, 1138769, 722812, 772338, 942980, 923898, 958982, 947582, 875276, 768109, 830456, 863738, 878197, 851127, 822758, 837880, 829397, 813516, 779593, 755188, 736707, 716007, 703380, 652648, 584981, 519082, 483890, 456218, 485704, 408019, 418802, 425281, 434577, 416025, 422685, 408532, 412144, 395749, 386773, 374984, 356343, 348591, 299702, 301233, 285955, 287917, 274893, 257872, 236470, 204823, 196629, 174108, 156046, 141592, 122399, 104678, 93412, 74288, 69542, 61070, 48496, 37435, 26989, 90344),
 F1970 = c(923747, 918033, 896539, 899735, 704595, 874181, 820453, 801151, 776092, 769556, 781493, 795746, 778547, 757184, 798338, 840987, 844452, 900183, 950239, 1008310, 1094581, 1205474, 1207813, 1147173, 727710, 782420, 960988, 939019, 967302, 952689, 880168, 771301, 836897, 864902, 872289, 845783, 817939, 833285, 817202, 803955, 770750, 750447, 731931, 722047, 727578, 699203, 659158, 646302, 623848, 594367, 619798, 504037, 512457, 514040, 518675, 486787, 493048, 476247, 484972, 459024, 442052, 428497, 398681, 388632, 327864, 339594, 316027, 327682, 315303, 299110, 281587, 243195, 240919, 216326, 200303, 185371, 165200, 146432, 135265, 111794, 110235, 100509, 81235, 68932, 52135, 209947),
 M1975 = c(980837, 1041105, 1056806, 1036530, 1012081, 983965, 966737, 946098, 948711, 738142, 918944, 859484, 839381, 814153, 805079, 812466, 829720, 804551, 778583, 814960, 851366, 843081, 898952, 951532, 1018595, 1103362, 1214051, 1213915, 1163269, 731692, 789707, 963771, 940695, 973225, 957193, 878565, 769926, 828800, 860589, 874686, 850764, 817817, 830778, 821141, 804563, 770596, 754499, 733964, 707929, 689513, 639983, 567794, 500850, 466798, 441346, 466183, 388137, 400652, 404747, 412957, 401738, 404392, 387778, 379769, 362146, 353144, 337272, 316586, 306461, 257765, 255307, 239083, 235218, 218501, 199813, 176213, 150713, 139452, 119441, 102487, 88949, 72662, 59397, 49517, 37238, 122647),
 F1975 = c(932920, 987681, 1007021, 983974, 961652, 931696, 917087, 898551, 902936, 704098, 876701, 820210, 801892, 777544, 768676, 778283, 797282, 777456, 757530, 797715, 831389, 829394, 890756, 945309, 1011135, 1094941, 1204615, 1200794, 1145510, 722434, 789418, 965423, 941185, 970172, 955002, 879482, 769409, 832457, 859833, 868573, 846881, 813730, 827352, 811558, 799486, 767543, 757206, 738139, 722615, 719406, 691231, 646365, 631278, 610805, 585255, 606829, 489455, 500247, 499565, 504877, 485151, 488809, 469139, 464361, 440451, 425512, 406371, 375420, 365171, 305335, 311343, 289041, 291948, 277260, 258368, 232586, 201738, 194408, 171111, 152858, 135504, 114723, 98159, 85172, 67382, 268153),
 M1980 = c(813741, 839734, 873852, 896520, 942253, 987894, 1043386, 1057899, 1038900, 1014408, 986691, 969928, 947950, 950553, 739691, 918958, 861039, 836807, 810042, 796839, 799070, 811388, 786000, 761782, 801876, 838484, 838094, 897409, 952586, 1018895, 1102659, 1215045, 1213414, 1162414, 728013, 783458, 959654, 934884, 967450, 949270, 868342, 760935, 818091, 849067, 862555, 834964, 801400, 812186, 801196, 783400, 750312, 732273, 712218, 688381, 663779, 616407, 546530, 480873, 447403, 420166, 442667, 366679, 376164, 378022, 382398, 369077, 367968, 348859, 338768, 318987, 306388, 287749, 265690, 251187, 206647, 200063, 181482, 173886, 155861, 137422, 116308, 94853, 83637, 68046, 54871, 171959),
 F1980 = c(772763, 796501, 832203, 852643, 895206, 939188, 990115, 1009314, 986149, 964781, 934427, 920572, 900343, 903934, 705539, 876000, 821082, 801324, 779779, 770375, 775654, 790713, 771947, 750422, 792174, 824578, 828292, 890109, 945249, 1007659, 1089823, 1200333, 1197681, 1142385, 719964, 785662, 963932, 939435, 967720, 950116, 872245, 763962, 825645, 853343, 863315, 838855, 806362, 819005, 803147, 789872, 758338, 745598, 728976, 719279, 700868, 678795, 633804, 618631, 599031, 571865, 592481, 474986, 484638, 482395, 484817, 463807, 465072, 445148, 434964, 412031, 394769, 373698, 341269, 326536, 269044, 270181, 246071, 243374, 224616, 203729, 177577, 148686, 137122, 114754, 97789, 357411),
 M1985 = c(731571, 761945, 770041, 772180, 783040, 818476, 839670, 873463, 897453, 943996, 987723, 1043746, 1058743, 1040855, 1015903, 989065, 973067, 948823, 950503, 738969, 913438, 848953, 824689, 795001, 783914, 788956, 803555, 784395, 764859, 806565, 844981, 842843, 899787, 952550, 1018104, 1099089, 1210092, 1207873, 1157498, 723678, 779447, 951201, 925656, 957375, 938198, 857144, 750030, 805068, 834371, 845508, 818507, 781316, 789879, 777909, 758803, 723393, 706655, 685056, 659422, 634848, 588200, 519717, 455343, 421907, 394735, 412027, 338300, 344947, 343324, 342410, 327545, 323387, 301237, 286874, 264552, 249358, 227758, 204353, 187366, 148593, 138303, 120889, 110605, 93824, 78622, 255975),
 F1985 = c(698087, 726418, 734869, 736535, 744577, 778147, 796802, 832698, 854417, 896712, 939806, 990877, 1010238, 988291, 965939, 935985, 922468, 902105, 908447, 710515, 879888, 819451, 797751, 773704, 763765, 771409, 788121, 771007, 751141, 793394, 826608, 828858, 889841, 943406, 1007246, 1088435, 1198240, 1195628, 1139419, 718092, 784180, 958867, 933504, 962058, 944468, 866148, 758637, 818539, 846194, 854975, 831392, 796367, 807635, 792944, 778242, 745855, 734709, 716348, 704493, 688966, 665583, 618809, 603566, 582863, 554815, 572575, 456446, 464967, 459762, 458661, 437434, 434946, 412616, 401006, 373800, 354081, 328472, 295232, 276112, 222018, 216393, 190592, 182019, 161227, 140463, 529272),
 M1990 = c(621085, 645402, 667257, 687831, 704464, 736058, 761634, 769649, 771683, 782809, 817406, 839095, 873298, 896453, 943628, 985737, 1042024, 1054881, 1034094, 1005479, 973949, 944150, 919825, 916854, 713421, 883781, 826886, 808914, 784220, 774668, 781953, 799044, 779718, 761121, 803517, 838061, 837748, 892900, 946671, 1009449, 1089260, 1201223, 1197000, 1145495, 717007, 769005, 937807, 911479, 944264, 919743, 839221, 733134, 787247, 814957, 822689, 789554, 755444, 761760, 749978, 726631, 691021, 673338, 650990, 624476, 596724, 549075, 481806, 420591, 386452, 356859, 370104, 299809, 303523, 295724, 290812, 273596, 263794, 240910, 222217, 196940, 179520, 157591, 135288, 117665, 88321, 357040),
 F1990 = c(592600, 615076, 634260, 655607, 669315, 702303, 726407, 734636, 736490, 744888, 777859, 797019, 832487, 853227, 896313, 937693, 988506, 1006504, 987020, 965149, 932473, 912977, 893522, 894019, 698931, 864869, 809441, 791595, 767843, 758496, 767364, 785240, 768365, 749202, 792161, 823055, 826834, 886971, 940406, 1001685, 1082127, 1192114, 1188137, 1132220, 713707, 776919, 949119, 924139, 953472, 932065, 854326, 747303, 809303, 835977, 844229, 815172, 785470, 795281, 781824, 763774, 730878, 718656, 700076, 686543, 672312, 643216, 597623, 581526, 558750, 527678, 543261, 429636, 436600, 425157, 422908, 397757, 391046, 366912, 348782, 316259, 293058, 264553, 230221, 207509, 159132, 765374),
 M1995 = c(609216, 614989, 606889, 619493, 619428, 629916, 649749, 672371, 690873, 706918, 736103, 762492, 770688, 773727, 783958, 820866, 843556, 875464, 898934, 946955, 981345, 1027784, 1036176, 1011951, 983972, 955370, 937672, 920132, 920151, 718800, 891348, 834566, 816403, 790825, 780707, 788702, 803470, 782578, 764634, 806425, 838188, 839141, 894531, 946993, 1008499, 1088256, 1200806, 1189535, 1138015, 711723, 759251, 927393, 900511, 928788, 905844, 825214, 719936, 769577, 793802, 798092, 762856, 725277, 726730, 710919, 686166, 648860, 628847, 603318, 573453, 544228, 496562, 430627, 371237, 336686, 306446, 312171, 247321, 245812, 233068, 222039, 202470, 188880, 164889, 145548, 122705, 479086),
 F1995 = c(582362, 586019, 578374, 588572, 589912, 601336, 619888, 638816, 658956, 671848, 703147, 727793, 736180, 737988, 745729, 779439, 798838, 832861, 857391, 903654, 937529, 981998, 999681, 977824, 956741, 927680, 914494, 895731, 895985, 702126, 868712, 813381, 795891, 772276, 762346, 771792, 787930, 770107, 752151, 794432, 823907, 827681, 886632, 940070, 1000430, 1080439, 1190322, 1181836, 1127009, 710425, 770095, 942760, 916903, 945590, 924783, 847365, 740576, 799998, 825167, 833753, 803717, 770370, 778710, 764339, 746025, 712209, 698390, 677929, 660247, 648597, 617346, 568608, 551080, 525290, 491285, 499901, 390885, 394301, 376651, 366918, 339728, 326261, 296485, 273661, 240138, 1100659),
 M2000 = c(600466, 596910, 610326, 607950, 606869, 615685, 618234, 608946, 620484, 620082, 634159, 646345, 673706, 692224, 706716, 738536, 765613, 772956, 772660, 784219, 823540, 834550, 858862, 874109, 916181, 955777, 1005385, 1020949, 1004494, 978672, 955040, 934421, 916453, 916005, 714899, 887876, 830981, 813476, 786872, 777081, 784295, 799822, 778822, 760715, 800517, 830052, 830544, 882903, 932313, 991960, 1068508, 1172217, 1165232, 1109956, 694125, 740133, 901083, 873685, 900734, 874604, 796438, 693530, 738582, 762043, 758935, 722261, 678589, 674979, 654568, 626884, 590373, 563026, 535445, 504578, 476848, 428635, 366138, 310938, 274724, 245387, 243345, 185705, 176442, 162064, 147712, 653475),
 F2000 = c(571186, 569250, 581831, 581353, 577957, 588448, 589508, 580020, 589798, 590584, 605357, 616000, 640697, 660282, 671126, 704392, 728441, 736916, 737769, 746663, 776798, 790541, 821808, 841135, 883936, 925199, 973691, 995701, 975953, 954488, 929220, 915242, 896745, 895971, 702614, 869898, 814511, 797785, 773125, 763260, 772350, 789135, 770634, 751750, 792179, 820721, 823375, 881209, 932586, 990345, 1070463, 1175634, 1170344, 1113337, 702174, 761830, 931715, 905769, 933340, 911279, 835779, 730911, 787932, 815024, 816659, 787956, 749661, 755222, 738010, 717809, 683298, 666734, 645390, 623437, 611447, 578338, 527533, 506633, 473975, 438299, 438440, 334513, 327377, 307963, 291128, 1579873),
 M2005 = c(539668, 557804, 571375, 588649, 597006, 607278, 604292, 610904, 608086, 605943, 616199, 617258, 608449, 620052, 618720, 632362, 653268, 675064, 696653, 716083, 741422, 753852, 757026, 746565, 755957, 786273, 806426, 838134, 861964, 905754, 949205, 999283, 1014512, 997497, 972768, 945606, 927533, 910300, 908866, 710482, 882923, 827731, 805966, 779029, 769821, 774589, 790161, 766938, 748341, 787471, 816353, 816299, 865997, 913501, 971090, 1043747, 1145025, 1135716, 1079446, 673435, 718324, 874355, 849367, 869302, 843181, 763350, 660974, 698526, 714359, 707797, 667385, 621368, 611177, 586033, 553780, 511696, 484419, 453050, 418680, 388472, 339083, 281960, 231663, 198904, 171025, 810898),
 F2005 = c(517132, 533512, 544274, 560801, 567866, 575699, 575444, 582445, 580785, 577619, 588325, 588164, 579067, 589196, 589222, 601812, 619808, 638398, 660443, 674489, 701168, 717475, 724303, 722848, 729982, 760627, 782125, 816883, 839660, 882203, 924371, 973483, 995080, 974451, 954207, 926907, 913562, 896126, 893579, 702820, 870861, 815550, 795941, 771168, 761606, 769944, 786091, 767125, 747451, 787750, 815028, 817565, 873788, 924649, 982229, 1060582, 1164429, 1157535, 1101184, 694065, 752586, 921463, 895682, 922336, 898033, 820761, 715569, 768743, 789694, 792837, 762627, 723176, 724894, 705863, 681194, 645035, 626316, 601320, 574415, 559398, 519961, 465704, 436403, 403387, 364303, 2115806),
 M2010 = c(535357, 534800, 549618, 547391, 543415, 541784, 561736, 572664, 587557, 596064, 603214, 602200, 611951, 608621, 605957, 625135, 630044, 617821, 623883, 612346, 620070, 633987, 655100, 671178, 685905, 711906, 734612, 744281, 745319, 755605, 789707, 810617, 844822, 866048, 909817, 952113, 1003334, 1019444, 1001440, 973791, 946353, 929854, 909126, 907805, 707237, 875220, 820099, 799335, 772698, 760617, 765827, 778349, 756737, 735910, 772753, 799902, 800001, 847340, 893276, 946970, 1017505, 1111132, 1099971, 1044270, 647590, 686748, 830331, 800182, 816330, 788183, 707137, 607840, 637594, 642992, 629940, 586255, 537517, 519347, 489295, 450526, 406441, 372484, 339041, 304029, 270589, 1047611),
 F2010 = c(510618, 510617, 524576, 522149, 518207, 516705, 537120, 544652, 560176, 567203, 572061, 574398, 583821, 581783, 577029, 593631, 595993, 584693, 592009, 587802, 599080, 615342, 633182, 650335, 662254, 692406, 714943, 725675, 730412, 738542, 771598, 790366, 825114, 846215, 887193, 928180, 978648, 997629, 977208, 954562, 927939, 916907, 898523, 895344, 702777, 868952, 812419, 795184, 770223, 758369, 766232, 781299, 763147, 742787, 781458, 808459, 811286, 866398, 916613, 973489, 1048918, 1150785, 1144348, 1088314, 684416, 740117, 902585, 874253, 898487, 872957, 793847, 690903, 739366, 757137, 756546, 722590, 679840, 677778, 654252, 623613, 583834, 559643, 529513, 497917, 472773, 2747322))

# Vital statistics of Japan from 1899 to 2010
Jvital <- data.frame(
YEAR = c(1899, 1900, 1901, 1902, 1903, 1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911, 1912, 1913, 1914, 1915, 1916, 1917, 1918, 1919, 1920, 1921, 1922, 1923, 1924, 1925, 1926, 1927, 1928, 1929, 1930, 1931, 1932, 1933, 1934, 1935, 1936, 1937, 1938, 1939, 1940, 1941, 1942, 1943, 1947, 1948, 1949, 1950, 1951, 1952, 1953, 1954, 1955, 1956, 1957, 1958, 1959, 1960, 1961, 1962, 1963, 1964, 1965, 1966, 1967, 1968, 1969, 1970, 1971, 1972, 1973, 1974, 1975, 1976, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010),
CBR = c(32, 32.4, 33.9, 33.6, 32.7, 31.2, 31.2, 29.6, 34, 34.7, 34.9, 34.8, 35.1, 34.4, 34.3, 34.8, 34.1, 33.7, 33.5, 32.7, 32.3, 36.2, 35.1, 34.3, 35.2, 33.9, 34.9, 34.6, 33.4, 34.1, 32.7, 32.4, 32.1, 32.9, 31.5, 29.9, 31.6, 30, 30.9, 27.2, 26.6, 29.4, 31.8, 30.9, 30.9, 34.3, 33.5, 33, 28.1, 25.3, 23.4, 21.5, 20, 19.4, 18.4, 17.2, 18, 17.5, 17.2, 16.9, 17, 17.3, 17.7, 18.6, 13.7, 19.4, 18.6, 18.5, 18.8, 19.2, 19.3, 19.4, 18.6, 17.1, 16.3, 15.5, 14.9, 14.2, 13.6, 13, 12.8, 12.7, 12.5, 11.9, 11.4, 11.1, 10.8, 10.2, 10, 9.9, 9.8, 9.6, 10, 9.6, 9.7, 9.5, 9.6, 9.4, 9.5, 9.3, 9.2, 8.9, 8.8, 8.4, 8.7, 8.6, 8.7, 8.5, 8.5),
CDR = c(21.5, 20.8, 20.9, 21.3, 20.4, 20.7, 21.6, 20.3, 21.4, 21.5, 22.5, 21.6, 20.9, 20.5, 20, 21.2, 20.7, 22.2, 22.2, 27.3, 23.3, 25.4, 22.7, 22.4, 22.9, 21.3, 20.3, 19.1, 19.7, 19.8, 19.9, 18.2, 19, 17.7, 17.7, 18.1, 16.8, 17.5, 17.1, 17.7, 17.8, 16.5, 16, 16.1, 16.7, 14.6, 11.9, 11.6, 10.9, 9.9, 8.9, 8.9, 8.2, 7.8, 8, 8.3, 7.4, 7.4, 7.6, 7.4, 7.5, 7, 6.9, 7.1, 6.8, 6.8, 6.8, 6.8, 6.9, 6.6, 6.5, 6.6, 6.5, 6.3, 6.3, 6.1, 6.1, 6, 6.2, 6.1, 6, 6.2, 6.2, 6.3, 6.2, 6.2, 6.5, 6.4, 6.7, 6.7, 6.9, 7.1, 7.1, 7.4, 7.2, 7.3, 7.5, 7.8, 7.7, 7.7, 7.8, 8, 8.2, 8.6, 8.6, 8.8, 9.1, 9.1, 9.5),
IMR = c(153.8, 155, 149.9, 154, 152.4, 151.9, 151.7, 153.6, 151.3, 158, 167.3, 161.2, 158.4, 154.2, 152.1, 158.5, 160.4, 170.3, 173.2, 188.6, 170.5, 165.7, 168.3, 166.4, 163.4, 156.2, 142.4, 137.5, 141.7, 137.6, 142.1, 124.1, 131.5, 117.5, 121.3, 124.8, 106.7, 116.7, 105.8, 114.4, 106.2, 90, 84.1, 85.5, 86.6, 76.7, 61.7, 62.5, 60.1, 57.5, 49.4, 48.9, 44.6, 39.8, 40.6, 40, 34.5, 33.7, 30.7, 28.6, 26.4, 23.2, 20.4, 18.5, 19.3, 14.9, 15.3, 14.2, 13.1, 12.4, 11.7, 11.3, 10.8, 10, 9.3, 8.9, 8.4, 7.9, 7.5, 7.1, 6.6, 6.2, 6, 5.5, 5.2, 5, 4.8, 4.6, 4.6, 4.4, 4.5, 4.3, 4.2, 4.3, 3.8, 3.7, 3.6, 3.4, 3.2, 3.1, 3, 3, 2.8, 2.8, 2.6, 2.6, 2.6, 2.4, 2.3),
NMR = c(77.9, 79, 77.1, 77.2, 75.8, 73.9, 71.2, 75.5, 73.5, 74.5, 76.5, 74.1, 72.8, 71.3, 70.7, 69.5, 69.7, 73.1, 77.1, 81.3, 72.6, 69, 68.5, 67.5, 66.3, 63.2, 58.1, 56.9, 56.4, 54.2, 55.4, 49.9, 51.7, 47.9, 48.5, 50.6, 44.7, 48.1, 43.8, 46.2, 44.3, 38.7, 34.2, 34.1, 33.8, 31.4, 27.5, 26.9, 27.4, 27.5, 25.4, 25.5, 24.1, 22.3, 23, 21.6, 19.5, 18.6, 17, 16.5, 15.3, 13.8, 12.4, 11.7, 12, 9.9, 9.8, 9.1, 8.7, 8.2, 7.8, 7.4, 7.1, 6.8, 6.4, 6.1, 5.6, 5.2, 4.9, 4.7, 4.2, 3.9, 3.7, 3.4, 3.1, 2.9, 2.7, 2.6, 2.6, 2.4, 2.4, 2.3, 2.3, 2.2, 2, 1.9, 2, 1.8, 1.8, 1.6, 1.7, 1.7, 1.5, 1.4, 1.3, 1.3, 1.2, 1.2, 1.1),
NIR = c(10.5, 11.6, 13, 12.3, 12.3, 10.5, 9.6, 9.3, 12.6, 13.2, 12.4, 13.2, 14.1, 13.9, 14.2, 13.6, 13.4, 11.5, 11.3, 5.5, 9, 10.8, 12.4, 11.9, 12.2, 12.6, 14.7, 15.5, 13.7, 14.4, 12.9, 14.2, 13.2, 15.2, 13.8, 11.8, 14.9, 12.4, 13.8, 9.4, 8.9, 12.9, 15.7, 14.7, 14.3, 19.7, 21.6, 21.4, 17.2, 15.4, 14.4, 12.6, 11.9, 11.6, 10.4, 8.9, 10.5, 10.1, 9.6, 9.5, 9.5, 10.3, 10.7, 11.4, 7, 12.7, 11.8, 11.7, 11.8, 12.6, 12.8, 12.8, 12.1, 10.8, 10, 9.4, 8.8, 8.3, 7.3, 6.9, 6.8, 6.5, 6.3, 5.6, 5.2, 4.9, 4.3, 3.7, 3.3, 3.2, 2.9, 2.5, 2.9, 2.1, 2.5, 2.2, 2.1, 1.6, 1.8, 1.6, 1.4, 0.9, 0.7, -0.2, 0.1, -0.1, -0.4, -0.6, -1.0),
SBRPB = c(89.1, 88.5, 93.8, 94.5, 93.6, 92.6, 89.1, 97, 89.6, 89.1, 87.1, 84.2, 81.6, 78.3, 77.6, 74.6, 72.8, 72, 71.9, 73.7, 69.5, 66.4, 65, 62.9, 61.5, 59.2, 56.3, 55.7, 53.7, 53.3, 53.3, 53.4, 52.5, 51.9, 51.1, 52.4, 50.1, 50.2, 48.6, 49.1, 49.2, 46, 43.4, 41, 39.6, 44.2, 50.9, 66.7, 84.9, 92.2, 92.3, 93.8, 95.6, 95.8, 97.1, 101.2, 100.7, 100.6, 100.4, 101.7, 98.8, 95.6, 89.2, 81.4, 98.2, 71.6, 71.1, 68.6, 65.3, 61.4, 57.8, 52.6, 51.3, 50.8, 52.7, 51.5, 48.7, 47.7, 46.8, 49.2, 49, 45.5, 46.3, 46, 45.3, 45.3, 43.4, 42.4, 42.3, 39.7, 38.9, 36.6, 33.5, 32.1, 31.7, 32.1, 31.4, 31.6, 31.2, 31, 31.1, 30.5, 30, 29.1, 27.5, 26.2, 25.2, 24.6, 24.2),
SARPB = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 36.9, 39.1, 41.7, 43, 42.8, 43.5, 44.6, 44.5, 46.9, 49.9, 50.2, 51.3, 52.3, 54.3, 54.2, 53.3, 51.7, 47.6, 55.2, 43.6, 43.4, 42.3, 40.6, 39.3, 37.8, 35.6, 34.9, 33.8, 33.1, 32.6, 31.1, 29.6, 28.8, 28.8, 27.7, 25.4, 24.3, 22.1, 21.4, 21.2, 19.5, 18.9, 18.3, 17.5, 17.2, 16.4, 15.4, 14.9, 14.7, 14.2, 13.6, 13.7, 13.2, 13, 12.7, 12.6, 12.5, 12.3, 11.9, 11.7, 11.3, 11.1, 11.2),
ACRPB = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 10.9, 25.9, 43.2, 49.3, 49.5, 50.2, 51.1, 51.3, 50.1, 51.3, 50.5, 49.3, 48.1, 47.4, 44.6, 42.4, 37.5, 33.8, 43.1, 28, 27.7, 26.3, 24.7, 22.1, 20.1, 17, 16.4, 17.1, 19.6, 18.9, 17.6, 18.1, 18, 20.5, 21.3, 20.1, 22, 23.9, 23.9, 24, 23.9, 23.5, 23.9, 22.1, 21.6, 20.2, 18.1, 17.2, 17, 17.9, 17.8, 17.9, 18.1, 18, 18.3, 17.8, 17.5, 16.7, 15.6, 14.5, 13.9, 13.5, 13.0),
PNMPB = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 21.6, 20.2, 19.5, 18.3, 16.9, 16.6, 15.4, 14.6, 13.7, 12.7, 12.1, 11.1, 8.5, 8.1, 7.7, 7.5, 7, 6.7, 6.4, 6.2, 6, 5.8, 5.5, 5.5, 5.3, 5, 4.8, 4.7, 4.5, 4.3, 4.2, 4.2),
MR = c(6.9, 7.9, 8.5, 8.8, 8.1, 8.6, 7.5, 7.5, 9.1, 9.6, 9, 9, 8.7, 8.5, 8.4, 8.7, 8.4, 8.1, 8.3, 9.1, 8.7, 9.8, 9.2, 9, 8.8, 8.7, 8.7, 8.3, 7.9, 8, 7.8, 7.9, 7.6, 7.8, 7.2, 7.5, 8, 7.8, 9.5, 7.6, 7.8, 9.3, 11, 9.4, 10.2, 12, 11.9, 10.3, 8.6, 7.9, 7.9, 7.8, 7.9, 8, 7.9, 8.5, 9, 9.1, 9.3, 9.4, 9.8, 9.7, 9.9, 9.7, 9.5, 9.6, 9.5, 9.6, 10, 10.5, 10.4, 9.9, 9.1, 8.5, 7.8, 7.2, 6.9, 6.8, 6.7, 6.6, 6.6, 6.4, 6.2, 6.1, 5.9, 5.7, 5.8, 5.8, 5.9, 6, 6.1, 6.4, 6.3, 6.4, 6.4, 6.2, 6.3, 6.1, 6.4, 6.4, 6, 5.9, 5.7, 5.7, 5.8, 5.7, 5.8, 5.6, 5.5),
DR = c(1.53, 1.46, 1.43, 1.43, 1.44, 1.39, 1.29, 1.39, 1.29, 1.26, 1.21, 1.21, 1.16, 1.17, 1.16, 1.15, 1.14, 1.13, 1.03, 1.03, 1.03, 0.99, 0.94, 0.92, 0.88, 0.88, 0.87, 0.83, 0.82, 0.78, 0.81, 0.8, 0.77, 0.77, 0.73, 0.71, 0.7, 0.66, 0.66, 0.63, 0.64, 0.68, 0.69, 0.64, 0.68, 1.02, 0.99, 1.01, 1.01, 0.97, 0.92, 0.86, 0.87, 0.84, 0.8, 0.79, 0.8, 0.78, 0.74, 0.74, 0.75, 0.73, 0.74, 0.79, 0.8, 0.84, 0.87, 0.89, 0.93, 0.99, 1.02, 1.04, 1.04, 1.07, 1.11, 1.14, 1.15, 1.17, 1.22, 1.32, 1.39, 1.51, 1.5, 1.39, 1.37, 1.3, 1.26, 1.29, 1.28, 1.37, 1.45, 1.52, 1.57, 1.6, 1.66, 1.78, 1.94, 2, 2.1, 2.27, 2.3, 2.25, 2.15, 2.08, 2.04, 2.02, 1.99, 2.01, 1.99),
TFR = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 5.11, NA, NA, NA, NA, 4.72, NA, NA, NA, NA, NA, NA, 4.37, 3.82, 3.74, 4.12, NA, NA, NA, NA, NA, NA, 4.54, 4.4, 4.32, 3.65, 3.26, 2.98, 2.69, 2.48, 2.37, 2.22, 2.04, 2.11, 2.04, 2, 1.96, 1.98, 2, 2.05, 2.14, 1.58, 2.23, 2.13, 2.13, 2.13, 2.16, 2.14, 2.14, 2.05, 1.91, 1.85, 1.8, 1.79, 1.77, 1.75, 1.74, 1.77, 1.8, 1.81, 1.76, 1.72, 1.69, 1.66, 1.57, 1.54, 1.53, 1.5, 1.46, 1.5, 1.42, 1.43, 1.39, 1.38, 1.34, 1.36, 1.33, 1.32, 1.29, 1.29, 1.26, 1.32, 1.34, 1.37, 1.37, 1.39),
ASMRM = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 23.6, 19.3, 18.9, 18.6, 16.9, 15.7, 16.4, 15.2, 14.8, 15.6, 16.3, 14.4, 14.4, 14.8, 14.3, 14.6, 13.4, 13.2, 13.7, 12.7, 12.6, 12.5, 12.4, 12.3, 11.5, 11.2, 11.2, 10.9, 10.4, 10.1, 9.6, 9.4, 9, 9.2, 8.9, 8.5, 8.6, 8.3, 8.1, 7.8, 7.6, 7.7, 7.4, 7.5, 7.4, 7.4, 7.3, 7.1, 7.2, 6.8, 6.7, 6.6, 6.7, 6.3, 6.2, 6, 6, 5.9, 5.9, 5.7, 5.6, 5.6, 5.4, 5.4),
ASMRF = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 18.3, 15.4, 15, 14.6, 13.4, 12.4, 12.6, 11.3, 11, 11.5, 11.8, 10.4, 10.2, 10.4, 10, 10, 9.3, 9.1, 9.3, 8.7, 8.5, 8.4, 8.2, 8.2, 7.6, 7.4, 7.4, 7.2, 6.9, 6.6, 6.2, 6, 5.7, 5.8, 5.6, 5.2, 5.2, 5, 4.8, 4.6, 4.4, 4.5, 4.2, 4.2, 4.1, 4, 4, 3.8, 3.8, 3.6, 3.5, 3.4, 3.4, 3.2, 3.1, 3, 3, 3, 3, 2.9, 2.8, 2.8, 2.7, 2.7),
PNMPLB = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 46.6, 46.7, 45.6, 46, 45.1, 43.9, 45.5, 45, 43.9, 43, 41.4, 40.9, 38.7, 36.2, 33.1, 30.1, 31.3, 26.3, 24.5, 23, 21.7, 20.4, 19, 18, 16.9, 16, 14.8, 14.1, 13, 12.5, 11.7, 10.8, 10.1, 9.3, 8.7, 8, 7.3, 6.9, 6.5, 6, 5.7, 5.3, 5.2, 5, 5, 4.7, 4.4, 4.2, 4.1, 4, 3.8, 3.6, 3.7, 3.6, 3.3, 3.3, 3.1, 3, 2.9, 2.9, 2.9))
