% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segm.R
\name{fm_segm}
\alias{fm_segm}
\alias{fm_segm.default}
\alias{fm_segm.fm_segm}
\alias{fm_segm.fm_segm_list}
\alias{fm_segm_join}
\alias{fm_segm_split}
\alias{fm_segm.inla.mesh.segment}
\alias{fm_segm.fm_mesh_2d}
\alias{fm_is_bnd}
\alias{fm_is_bnd<-}
\title{Make a spatial segment object}
\usage{
fm_segm(...)

\method{fm_segm}{default}(loc = NULL, idx = NULL, grp = NULL, is.bnd = TRUE, crs = NULL, ...)

\method{fm_segm}{fm_segm}(..., grp = NULL, grp.default = 0L, is.bnd = NULL)

\method{fm_segm}{fm_segm_list}(x, grp = NULL, grp.default = 0L, ...)

fm_segm_join(x, grp = NULL, grp.default = 0L, is.bnd = NULL)

fm_segm_split(x, grp = NULL, grp.default = 0L)

\method{fm_segm}{inla.mesh.segment}(..., grp.default = 0)

\method{fm_segm}{fm_mesh_2d}(x, boundary = TRUE, grp = NULL, ...)

fm_is_bnd(x)

fm_is_bnd(x) <- value
}
\arguments{
\item{...}{Passed on to submethods}

\item{loc}{Matrix of point locations, or \code{SpatialPoints}, or \code{sf}/\code{sfc} point
object.}

\item{idx}{Segment index sequence vector or index pair matrix.  The indices
refer to the rows of \code{loc}.  If \code{loc==NULL}, the indices will be
interpreted as indices into the point specification supplied to
\code{\link[=fm_rcdt_2d]{fm_rcdt_2d()}}.  If \code{is.bnd==TRUE}, defaults to linking
all the points in \code{loc}, as \code{c(1:nrow(loc),1L)}, otherwise
\code{1:nrow(loc)}.}

\item{grp}{When joining segments, use these group labels for segments
instead of the original group labels.}

\item{is.bnd}{\code{TRUE} if the segments are boundary segments, otherwise
\code{FALSE}.}

\item{crs}{An optional \code{fm_crs()}, \code{sf::st_crs()} or \code{sp::CRS()} object}

\item{grp.default}{If \code{grp.default} is \code{NULL}, use these group labels for
segments with NULL group.}

\item{x}{Mesh to extract segments from}

\item{boundary}{logical; if \code{TRUE}, extract the boundary segments,
otherwise interior constrain segments.}

\item{value}{logical}
}
\value{
An \code{fm_segm} or \code{fm_segm_list} object
}
\description{
Make a spatial segment object
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_segm(fm_segm)}: Join multiple \code{fm_segm} objects into a single \code{fm_segm}
object. If \code{is.bnd} is non-NULL, it overrides the input segment information.
Otherwise, it checks if the inputs are consistent.

\item \code{fm_segm(fm_segm_list)}: Join \code{fm_segm} objects from a \code{fm_segm_list} into
a single \code{fm_segm} object. Equivalent to \code{fm_segm_join(x)}

\item \code{fm_segm(fm_mesh_2d)}: Extract the boundary or interior segments of a 2d mesh.
If \code{grp} is non-NULL, extracts only segments matching the matching the set
of groups given by \code{grp}.

}}
\section{Functions}{
\itemize{
\item \code{fm_segm()}: Create a new \code{fm_segm} object.

\item \code{fm_segm_join()}: Join multiple \code{fm_segm} objects into a single \code{fm_segm}
object. If \code{is.bnd} is non-NULL, it overrides the segment information.
Otherwise it checks for consistency.

\item \code{fm_segm_split()}: Split an \code{fm_segm} object by \code{grp} into an \code{fm_segm_list}
object, optionally keeping only some groups.

}}
\examples{
fm_segm(rbind(c(0, 0), c(1, 0), c(1, 1), c(0, 1)), is.bnd = FALSE)
fm_segm(rbind(c(0, 0), c(1, 0), c(1, 1), c(0, 1)), is.bnd = TRUE)

fm_segm_join(fmexample$boundary_fm)

fm_segm(fmexample$mesh, boundary = TRUE)
fm_segm(fmexample$mesh, boundary = FALSE)

}
\seealso{
Other object creation and conversion: 
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_segm}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_lattice_Nd}()},
\code{\link{fm_mesh_1d}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_simplify}()},
\code{\link{fm_tensor}()}
}
\concept{object creation and conversion}
