% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-schedule.R
\name{generate_schedule}
\alias{generate_schedule}
\title{Generate a date schedule}
\usage{
generate_schedule(effective_date, termination_date, tenor,
  calendar = EmptyCalendar(), bdc = "u", stub = "short_front",
  eom_rule = FALSE, first_date = effective_date,
  last_date = termination_date)
}
\arguments{
\item{effective_date}{the date at which the schedule begins. For example, the
effective date of a swap. This should be \code{\link{POSIXct}}.}

\item{termination_date}{the date at which the schedule ends. For example, the
termination date of a swap. This should be \code{\link{POSIXct}}.}

\item{tenor}{the frequency of the events for which dates are generated. For
example, \code{month(3)} reflects events that occur quarterly. Should be an
atomic \code{\link{Period-class}} of length one}

\item{calendar}{a \code{\link{Calendar}}}

\item{bdc}{a string representing one of the following business day
conventions: "u", "f", "mf", "p", "mp", "ms" (unadjusted, following,
modified following, preceding, modified preceding and modified succeeding,
resp.)}

\item{stub}{a string representing one of the following stub types:
"short_front", "short_back", "long_front", "long_back".}

\item{eom_rule}{a logical value defining whether the end-to-end convention
applies.}

\item{first_date}{date of first payment for example. This defaults to
\code{effective_date} as is usually the case}

\item{last_date}{date of last payment for example. This defaults to
\code{termination_date} as is usually the case}
}
\value{
an \code{Interval} vector
}
\description{
Generate a date schedule from \code{effective_date} to
\code{termination_date}. This code was derived from the Quantlib method
Schedule::Schedule. This can be used to generate the cash flow, fixing and
projection dates of an interest rate swap according to certain conventions.
}
\examples{
library (lubridate)
effective_date <- ymd('20120103')
termination_date <- ymd('20121203')
tenor <- months(3)
stub <- 'short_front'
bdc <- 'mf'
calendar <- AUSYCalendar()
eom_rule <- FALSE
generate_schedule(effective_date, termination_date, tenor, calendar,
 bdc, stub, eom_rule)
}
\seealso{
Other calendar methods: \code{\link{adjust}},
  \code{\link{is_good}}, \code{\link{is_valid_bdc}},
  \code{\link{is}}, \code{\link{locale}},
  \code{\link{shift}}, \code{\link{tz}}
}
