% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interest-rate-classes.R
\name{as_InterestRate}
\alias{as_InterestRate}
\alias{as_InterestRate.DiscountFactor}
\alias{as_InterestRate.InterestRate}
\title{Coerce to InterestRate}
\usage{
as_InterestRate(x, ...)

\method{as_InterestRate}{DiscountFactor}(x, compounding, day_basis, ...)

\method{as_InterestRate}{InterestRate}(x, compounding = NULL,
  day_basis = NULL, ...)
}
\arguments{
\item{x}{object to coerce}

\item{...}{other parameters passed to methods}

\item{compounding}{a numeric vector representing the \link{compounding} frequency.}

\item{day_basis}{a character vector representing the day basis associated
with the interest rate (see \code{\link[fmdates:year_frac]{fmdates::year_frac()}})}
}
\value{
an \code{InterestRate} object
}
\description{
You can coerce objects to the \code{InterestRate} class using this method.
}
\examples{
library("lubridate")
as_InterestRate(DiscountFactor(0.95, ymd(20130101), ymd(20140101)),
  compounding = 2, day_basis = "act/365")
as_InterestRate(InterestRate(c(0.04, 0.05), c(2, 4), 'act/365'),
  compounding = 4, day_basis = 'act/365')
}
