% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_fitting_zhao18.R
\name{flux_fitting_zhao18}
\alias{flux_fitting_zhao18}
\title{Fitting a model to the gas concentration curve and estimating the slope
over time, using the exponential model from Zhao et al (2018)}
\usage{
flux_fitting_zhao18(
  conc_df_cut,
  conc_df,
  conc_col,
  f_start,
  f_fluxid,
  start_cut,
  cz_window,
  b_window,
  a_window,
  roll_width
)
}
\arguments{
\item{conc_df_cut}{dataframe of gas concentration over time, cut}

\item{conc_df}{dataframe of gas concentration over time}

\item{conc_col}{column with gas concentration}

\item{f_start}{column with datetime when the measurement started}

\item{f_fluxid}{column with ID of each flux}

\item{start_cut}{time to discard at the start of the measurements
(in seconds)}

\item{cz_window}{window used to calculate Cz, at the beginning of cut window}

\item{b_window}{window to estimate b. It is an interval after tz
where it is assumed that C fits the data perfectly}

\item{a_window}{window at the end of the flux to estimate a}

\item{roll_width}{width of the rolling mean for CO2 when looking for tz,
ideally same as cz_window}
}
\value{
a dataframe with the slope at t zero,
modeled concentration over time and exponential expression parameters
}
\description{
Fits an exponential expression to the concentration evolution
}
\references{
Zhao, P., Hammerle, A., Zeeman, M., Wohlfahrt, G., 2018.
On the calculation of daytime CO2 fluxes measured by automated closed
transparent chambers. Agricultural and Forest Meteorology 263, 267–275.
https://doi.org/10.1016/j.agrformet.2018.08.022
}
