% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{get_status}
\alias{get_status.character}
\alias{get_status.data.frame}
\alias{get_status.flow}
\alias{status}
\title{status}
\usage{
status(x, out_format = "markdown")

get_status(x, ...)

\method{get_status}{character}(x, out_format = "markdown", ...)

\method{get_status}{data.frame}(x, ...)

\method{get_status}{flow}(x, out_format = "markdown", ...)
}
\arguments{
\item{x}{path to the flow root folder or a parent folder to summarize several flows.}

\item{out_format}{passed onto knitr:::kable. supports: markdown, rst, html...}

\item{...}{not used}
}
\description{
Summarize status of executed flow(x)
}
\details{
basename(x) is used in a wild card search.

\itemize{
\item If x is a path with a single flow, it outputs the status of one flow.
\item If the path has more than one flow then this could give a summary of **all** of them.
\item Instead if x is supplied with paths to more than one flow, then this individually prints status of each.
}

Alternatively, x can also be a flow object
}
\examples{
\dontrun{
status(x = "~/flowr/runs/sleep_pipe*")
## an example for running from terminal
flowr status x=path_to_flow_directory cores=6
}
}

