% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{cluster_flows_dbscan}
\alias{cluster_flows_dbscan}
\title{Cluster Flows using DBSCAN}
\usage{
cluster_flows_dbscan(dist_mat, w_vec, x, eps, minPts)
}
\arguments{
\item{dist_mat}{distance matrix}

\item{w_vec}{weight vector}

\item{x}{flows tibble with flow_ID}

\item{eps}{DBSCAN epsilon parameter}

\item{minPts}{DBSCAN minPts parameter}
}
\value{
flows tibble with an additional cluster column
}
\description{
See \link[dbscan]{dbscan} for details on the DBSCAN algorithm.
}
\examples{
flows <- sf::st_transform(flows_leeds, 3857)
flows <- head(flows, 100) # for testing
# Add flow lengths and coordinates
flows <- add_flow_length(flows)
# filter by length
flows <- filter_by_length(flows, length_min = 5000, length_max = 12000)
flows <- add_xyuv(flows)
# Calculate distances
distances <- flow_distance(flows, alpha = 1.5, beta = 0.5)
dmat <- distance_matrix(distances)
wvec <- weight_vector(dmat, flows, weight_col = "count")
clustered <- cluster_flows_dbscan(dmat, wvec, flows, eps = 8, minPts = 70)
}
