% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_attributes.R
\name{get_attributes}
\alias{get_attributes}
\title{Get available attributes to filter species}
\usage{
get_attributes(data, attribute, Kingdom = "Plantae")
}
\arguments{
\item{data}{(data.frame) a data.frame imported with the
\code{\link{load_florabr}} function or a data.frame generated with the
\code{\link{select_species}} function.}

\item{attribute}{(character) the type of characteristic. See detail to see
the options.}

\item{Kingdom}{(character) the kingdom to which the species belong. It can
be "Plantae" or "Fungi". Default = "Plantae".}
}
\value{
a data.frame with two columns. The first column provides the
available options in English. Use this options in the
\code{\link{select_species}} function. The second columns provides the
options in Portuguese.
}
\description{
This function displays all the options available to filter species by its
characteristics
}
\details{
The attribute argument accepts the following options: Group, SubGroup,
family, lifeForm, habitat, vegetationType, Origin, Endemism, Biome, States,
taxonomicStatus or nomenclaturalStatus". These options represent different
characteristics of species that can be used for filtering.
}
\examples{
data("bf_data") #Load Brazilian Flora data
# Get available biomes to filter species
get_attributes(data = bf_data, Kingdom = "Plantae", attribute = "Biome")
# Get available life forms to filter species
get_attributes(data = bf_data, Kingdom = "Plantae", attribute = "lifeForm")
# Get available states to filter species
get_attributes(data = bf_data, Kingdom = "Plantae", attribute = "States")
}
\references{
Brazilian Flora 2020. Jardim Botânico do Rio de Janeiro. Available at:
http://floradobrasil.jbrj.gov.br/
}
