% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz.R
\name{plot_pf}
\alias{plot_pf}
\title{Visualization of Plausibility Functions}
\usage{
plot_pf(pf, alpha = 0.05, ngrid = 10, ncores = 1, subtitle = "")
}
\arguments{
\item{pf}{A \code{\link{PlausibilityFunction}} object.}

\item{alpha}{A numeric value specifying a significance level to contrast the
plausibility function against. Defaults to \code{0.05}.}

\item{ngrid}{An integer specifying the grid size on which the plausibility
function will be evaluated. Specifically if \code{K} is the number of parameters
under investigation, the grid will be of size \code{(ngrid + 1)^K}. Defaults to
\code{10L}.}

\item{ncores}{An integer specifying the number of cores to use for
parallelized computations. Defaults to \code{1L}.}

\item{subtitle}{A string for specifying a subtitle to the plot. Defaults to
\code{""} leading to no subtitle.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
This function plots the plausibility function for up to two parameters of
interest.
}
\examples{
x <- rnorm(10)
y <- rnorm(10, mean = 2)
null_spec <- function(y, parameters) {purrr::map(y, ~ .x - parameters[1])}
stat_functions <- list(stat_t)
stat_assignments <- list(mean = 1)
pf <- PlausibilityFunction$new(
  null_spec = null_spec,
  stat_functions = stat_functions,
  stat_assignments = stat_assignments,
  x, y
)
pf$set_nperms(50)
pf$set_point_estimate(mean(y) - mean(x))
pf$set_parameter_bounds(
  point_estimate = pf$point_estimate,
  conf_level = 0.8
)
pf$set_grid(
  parameters = pf$parameters,
  npoints = 2L
)
pf$evaluate_grid(grid = pf$grid)
plot_pf(pf)
}
