% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-sample-pe.R
\name{two_sample_pe}
\alias{two_sample_pe}
\title{Two-Sample Permutation Point Estimate}
\usage{
two_sample_pe(
  null_specification,
  x,
  y,
  statistic = stat_hotelling,
  B = 1000,
  alternative = "two_tail",
  type = "exact",
  lower_bound = 0,
  upper_bound = 1,
  seed = NULL,
  verbose = FALSE
)
}
\arguments{
\item{null_specification}{A function with two arguments \code{y} and \code{parameters}
such that \verb{F_X = F_\{null_specification(Y, parameters)\}} under the null
hypothesis.}

\item{x}{A list or matrix representing the 1st sample.}

\item{y}{A list or matrix representing the 2nd sample.}

\item{statistic}{A character vector specifying the chosen test statistic(s).
These can be \code{\link{stat_hotelling}} or user-specified functions that
define desired statistics. See the section \emph{User-supplied statistic
function} for more information on how these user-supplied functions should
be structured for compatibility with the \strong{flipr} framwork. Default is
\code{\link{stat_hotelling}}.}

\item{B}{The number of sampled permutation. Default is \code{1000L}.}

\item{alternative}{A string specifying whether the p-value is right-tailed,
left-tailed or two-tailed. Choices are \code{"right_tail"}, \code{"left_tail"} and
\code{"two_tail"}. Default is \code{"right_tail"}. Obviously, if the test statistic
used in argument \code{statistic} is positive, all alternatives will lead to the
two-tailed p-value.}

\item{type}{A string specifying if performing an exact test through the use
of Phipson-Smyth estimate of the p-value or an approximate test through a
Monte-Carlo estimate of the p-value. Default is \code{"exact"}.}

\item{lower_bound}{A scalar value specifying a rough lower bound of the
interval over which searching the maximum of the p-value function. Default
is \code{0}.}

\item{upper_bound}{A scalar value specifying a rough upper bound of the
interval over which searching the maximum of the p-value function. Default
is \code{1}.}

\item{seed}{An integer specifying the seed of the random generator useful for
result reproducibility or method comparisons. Default is \code{NULL}.}

\item{verbose}{A boolean specifying whether to display some information about
the resolution of the maximization problem. Default is \code{FALSE}.}
}
\value{
A numerical vector providing a point estimate of the parameters.
}
\description{
This function produces a point estimate of the parameters under investigation
using the permutation framework.
}
\examples{
x1 <- rnorm(10)
x2 <- rnorm(10, mean = 3)
null_spec <- function(y, parameters) {y - parameters[1]}
two_sample_pe(
  null_specification = null_spec,
  x = x1, y = x2,
  statistic = stat_t,
  lower_bound = 2,
  upper_bound = 4
)
}
