% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_funs.R
\name{hyperlink_text}
\alias{hyperlink_text}
\title{hyperlink wrapper}
\usage{
hyperlink_text(url, label = url)
}
\arguments{
\item{url, label}{url and label to be used}
}
\description{
The function has to be used with function display().
It lets add hyperlinks within flextable.
}
\examples{
dat <- data.frame(
  col = "CRAN website", href = "https://cran.r-project.org",
  stringsAsFactors = FALSE)

ft <- flextable(dat)
ft <- display(
  ft, col_key = "col", pattern = "# {{mylink}}",
  formatters = list(mylink ~ hyperlinked_text(href, col) )
)
ft


dat <- data.frame(
  col = "Google it",
  href = "https://www.google.fr/search?source=hp&q=officer+R+package",
  stringsAsFactors = FALSE)

ft <- flextable(dat)
ft <- display( x = ft,
  col_key = "col",
  pattern = "This is a link: {{mylink}}",
  formatters = list(mylink ~ hyperlink_text(href, col) ) )
ft
}
\seealso{
\code{\link{display}}
}
