% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{style}
\alias{style}
\title{Set flextable style}
\usage{
style(x, i = NULL, j = NULL, pr_t = NULL, pr_p = NULL, pr_c = NULL,
  part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{pr_t}{object(s) of class \code{fp_text}}

\item{pr_p}{object(s) of class \code{fp_par}}

\item{pr_c}{object(s) of class \code{fp_cell}}

\item{part}{partname of the table (one of 'all', 'body', 'header')}
}
\description{
Modify flextable text, paragraphs and cells formatting properties.
}
\examples{
library(officer)
def_cell <- fp_cell(border = fp_border(color="#00FFFF"))

def_par <- fp_par(text.align = "center")

ft <- flextable(mtcars)

ft <- style( ft, pr_c = def_cell, pr_p = def_par, part = "all")
ft <- style(ft, ~ drat > 3.5, ~ vs + am + gear + carb,
  pr_t = fp_text(color="red", italic = TRUE) )

ft
}
