% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulartable.R
\name{set_formatter}
\alias{set_formatter}
\title{set column formatter functions}
\usage{
set_formatter(x, ..., part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{...}{Name-value pairs of functions, names should be existing col_key values}

\item{part}{partname of the table (one of 'body' or 'header')}
}
\description{
Define formatter functions associated to each column key.
Functions have a single argument (the vector) and are returning the formatted
values as a character vector.
}
\examples{
ft <- regulartable( head( iris ) )
ft <- set_formatter( x = ft,
        Sepal.Length = function(x) sprintf("\%.02f", x),
        Sepal.Width = function(x) sprintf("\%.04f", x)
      )
ft <- theme_vanilla( ft )
ft
}
