% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexsurv-package.R
\docType{data}
\name{bos}
\alias{bos}
\alias{bosms3}
\alias{bosms4}
\title{Bronchiolitis obliterans syndrome after lung transplants}
\format{A data frame containing a sequence of observed or censored
transitions to the next stage of severity or death.  It is grouped
by patient and includes histories of 204 patients.  All patients
start in state 1 (no BOS) at six months after transplant, and may
subsequently develop BOS or die.

\code{bosms3} contains the data for a three-state model: no BOS, BOS or
death. \code{bosms4} uses a four-state representation: no BOS, mild BOS,
moderate/severe BOS or death.  \tabular{rll}{ \code{id} \tab (numeric) \tab
Patient identification number \cr \code{from} \tab (numeric) \tab Observed
starting state of the transition \cr \code{to} \tab (numeric) \tab Observed
or potential ending state of the transition \cr \code{Tstart} \tab
(numeric) \tab Time at the start of the interval \cr \code{Tstop} \tab
(numeric) \tab Time at the end of the interval \cr \code{time} \tab
(numeric) \tab Time difference \code{Tstart}-\code{Tstop} \cr \code{status}
\tab (numeric) \tab 1 if the transition to state \code{to} was observed, or
0 if the transition to state \code{to} was censored (for example, if the
patient was observed to move to a competing state) \cr \code{trans} \tab
(factor) \tab Number of the transition \code{from}-\code{to} in the set of
all \code{ntrans} allowed transitions, numbered from 1 to \code{ntrans}.  }}
\source{
Papworth Hospital, U.K.
}
\description{
A dataset containing histories of bronchiolitis obliterans syndrome (BOS)
from lung transplant recipients. BOS is a chronic decline in lung function,
often observed after lung transplantation.
}
\details{
The entry time of each patient into each stage of BOS was estimated by
clinicians, based on their history of lung function measurements and acute
rejection and infection episodes.  BOS is only assumed to occur beyond six
months after transplant.  In the first six months the function of each
patient's new lung stabilises.  Subsequently BOS is diagnosed by comparing
the lung function against the "baseline" value.

The same data are provided in the \pkg{msm} package, but in the
native format of \pkg{msm} to allow Markov models to be fitted.
In \pkg{flexsurv}, much more flexible models can be fitted.
}
\references{
Heng. D. et al. (1998).  Bronchiolitis Obliterans Syndrome:
Incidence, Natural History, Prognosis, and Risk Factors.  Journal of Heart
and Lung Transplantation 17(12)1255--1263.
}
\keyword{datasets}
