\name{totlos.fs}
\alias{totlos.fs}
\title{Total length of stay in particular states for a fully-parametric,
  time-inhomogeneous Markov multi-state model}
\description{
  The matrix whose \eqn{r,s} entry is the expected amount of time
  spent in state \eqn{s} for a time-inhomogeneous, continuous-time Markov
  multi-state process that starts in state \eqn{r}, up to a maximum time
  \eqn{t}. This is defined
  as the integral of the corresponding transition probability up to that time.
}
\usage{
  totlos.fs(x, trans, t=1, newdata=NULL, ci=FALSE, tvar="trans",
             sing.inf=1e+10, B=1000, cl=0.95, ...)
}
\arguments{
  \item{x}{A model fitted with \code{\link{flexsurvreg}}.   See
    \code{\link{msfit.flexsurvreg}}
    for the required form of the model and the data.
    Additionally, this must be a Markov / clock-forward model,
    but can be time-inhomogeneous.  See the package vignette for further
    explanation. 
  }
  \item{trans}{Matrix indicating allowed transitions.  See
    \code{\link{msfit.flexsurvreg}}.}
  \item{t}{Time or vector of times to predict up to.  Must be finite.}
  \item{newdata}{A data frame specifying the values of covariates in
    the fitted model, other than the transition number.  See
    \code{\link{msfit.flexsurvreg}}. 
  }
  \item{ci}{Return a confidence interval calculated by simulating from
    the asymptotic normal distribution of the maximum likelihood
    estimates.  Turned off by default, since this is computationally
    intensive.   If turned on, users should increase
    \code{B} until the results reach the desired precision.}
  \item{tvar}{Variable in the data representing the transition type.}
  \item{sing.inf}{If there is a singularity in the observed hazard,
    for example a Weibull distribution with \code{shape < 1} has infinite
    hazard at \code{t=0}, then as a workaround, the hazard is assumed to
    be a large finite number, \code{sing.inf}, at this time.   The
    results should not be sensitive to the exact value assumed, but
    users should make sure by adjusting this parameter in these cases.
  }
  \item{B}{Number of simulations from the normal asymptotic distribution
    used to calculate variances.  Decrease for greater speed at the
    expense of accuracy.}
  \item{cl}{Width of symmetric confidence intervals, relative to 1.}
  \item{...}{Arguments passed to \code{\link{ode}} in \pkg{deSolve}.}
}
\value{
  The matrix of lengths of stay \eqn{T(t)}, if \code{t} is of length 1, or a
  list of matrices if \code{t} is longer.

  If \code{ci=TRUE}, each element has attributes \code{"lower"} and
  \code{"upper"} giving matrices of the corresponding confidence limits.
  These are formatted for printing but may be extracted using
  \code{attr()}.

  The result also has an attribute \code{P} giving the transition
  probability matrices, since these are unavoidably computed as a side
  effect.  These are suppressed for printing, but can be extracted with
  \code{attr(...,"P")}.
}
\details{
  This is computed by solving a second order extension of the Kolmogorov
  forward differential equation numerically, using the methods in the
  \code{\link{deSolve}} package.  The equation is expressed as a linear
  system

  \deqn{\frac{dT(t)}{dt} = P(t)}
  \deqn{\frac{dP(t)}{dt} = P(t) Q(t)}

  and solved for \eqn{T(t)} and \eqn{P(t)} simultaneously, where
  \eqn{T(t)} is the matrix of total lengths of stay, \eqn{P(t)} is the transition
  probability matrix for time \eqn{t}, and \eqn{Q(t)} is the transition
  hazard or intensity as a function of \eqn{t}.  The initial conditions
  are \eqn{T(0) = 0} and \eqn{P(0) = I}.

  Note that the package \pkg{msm} has a similar method
  \code{totlos.msm}.  \code{totlos.fs} should give the same results as
  \code{totlos.msm} when both of these conditions hold:

  \itemize{
    \item the time-to-event distribution is exponential for all
    transitions, thus the \code{flexsurvreg} model was fitted with
    \code{dist="exp"}, and is time-homogeneous.
    \item the \pkg{msm} model was fitted with \code{exacttimes=TRUE},
    thus all the event times are known, and there are no time-dependent covariates.
  }

  \pkg{msm} only allows exponential or piecewise-exponential
  time-to-event distributions, while \pkg{flexsurvreg} allows more
  flexible models.   \pkg{msm} however was designed in particular for
  panel data, where the process is observed only at arbitrary times,
  thus the times of transition are unknown, which makes flexible models
  difficult.

  This function is only valid for Markov ("clock-forward") multi-state
  models, though no warning or error is currently given if the model is
  not Markov.   See \code{\link{totlos.simfs}} for the equivalent for
  semi-Markov ("clock-reset") models.
}
\seealso{
  \code{\link{totlos.simfs}}, \code{\link{pmatrix.fs}}, \code{\link{msfit.flexsurvreg}}.
}
\examples{
# BOS example in vignette, and in msfit.flexsurvreg
bexp <- flexsurvreg(Surv(Tstart, Tstop, status) ~ trans,
                    data=bosms3, dist="exp")
tmat <- rbind(c(NA,1,2),c(NA,NA,3),c(NA,NA,NA))

# predict 4 years spent without BOS, 3 years with BOS, before death
# As t increases, this should converge

totlos.fs(bexp, t=10, trans=tmat)
totlos.fs(bexp, t=1000, trans=tmat)
totlos.fs(bexp, t=c(5,10), trans=tmat)

# Answers should match results in help(totlos.simfs) up to Monte Carlo
# error there / ODE solving precision here, since with an exponential
# distribution, the "semi-Markov" model there is the same as the Markov
# model here
}
\author{Christopher Jackson \email{chris.jackson@mrc-bsu.cam.ac.uk}.}
\keyword{models,survival}
