% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_excel_sheet.R
\name{read_excel_sheet}
\alias{read_excel_sheet}
\title{Import Excel file sheet}
\usage{
read_excel_sheet(
  file,
  sheetIndex = 1,
  sheetName = NULL,
  encoding = "UTF-8",
  password = NULL
)
}
\arguments{
\item{file}{A string, name of an Excel file.}

\item{sheetIndex}{A number, sheet index in the workbook.}

\item{sheetName}{A string, sheet name.}

\item{encoding}{A string, encoding to be assumed for input strings.}

\item{password}{A string with the password (if required).}
}
\value{
A \code{pivot_table} object.
}
\description{
Reads an Excel file sheet and creates a \code{pivot_table} object. The sheet is
expected to contain one or more pivot tables. Each line in the sheet
corresponds to a row in a table. The file and sheet names are included as
part of the object attributes.
}
\details{
When multiple files or sheets are handled, the file and/or sheet names may
contain information associated with the pivot table, they could be the table
page information. In order not to lose this information, they are always
stored in the \code{pivot_table} object.
}
\examples{
file <- system.file("extdata", "excel/ine2871.xlsx", package = "flattabler")
# pt <- read_excel_sheet(file)

# pt <- read_excel_sheet(file, sheetName = "tabla-2871")

}
\seealso{


Other import functions: 
\code{\link{pivot_table}()},
\code{\link{read_excel_file}()},
\code{\link{read_excel_folder}()},
\code{\link{read_text_file}()},
\code{\link{read_text_folder}()}
}
\concept{import functions}
