context("Base: Print Feature Object")

test_that("FeatureObject Output", {
  feat.object = createFeatureObject(iris, objective = "Species")
  expect_output(print(feat.object), regexp = paste(
    "^Feature Object:",
    "- Number of Observations:\\s\\d+",
    "- Number of Features:\\s\\d+",
    "- Lower Boundaries: [0-9e+.-]+(, [0-9e+-.]+)*",
    "- Upper Boundaries: [0-9e+.-]+(, [0-9e+-.]+)*",
    "- Name of Features: [^,\\s]*(, [^,\\s]*)*",
    "- Optimization Problem: (minimize|maximize) [^\\s]+?",
    sep="\\r?\\n")
  )
})

test_that("FeatureObject Output with more than 5 feature dims", {
  init = matrix(1, ncol=6, nrow=2)
  colnames(init) = c("a1", "a2", "a3", "a4", "a5", "a6")
  feat.object = createFeatureObject(init, objective = "a6")
  expect_output(print(feat.object), regexp = paste(
    "- Lower Boundaries: [0-9e+.-]+(, [0-9e+-.]+)*, ...",
    "- Upper Boundaries: [0-9e+.-]+(, [0-9e+-.]+)*, ...",
    "- Name of Features: [^,\\s]*(, [^,\\s]*)*, ...",
    sep="\\r?\\n")
  )
})

test_that("FeatureObject Output with a function", {
  init = matrix(1L, ncol = 6L, nrow = 2L)
  colnames(init) = c("a1", "a2", "a3", "a4", "a5", "a6")
  feat.object = createFeatureObject(init, objective = "a6", fun = function (x) sum(x^2))
  expect_output(print(feat.object),
    regexp = "- Function to be Optimized: function \\(x\\) sum\\(x\\^2\\)")
})

test_that("FeatureObject Output with cellmapping and dim < 5", {
  init = matrix(1:10, ncol = 5L, nrow = 10L)
  colnames(init) = c("a1", "a2", "a3", "a4", "a5")
  feat.object = createFeatureObject(init, objective = "a5", blocks = 4L)
  expect_output(print(feat.object), regexp = paste(
    "- Number of Cells per Dimension: \\d+(, \\d+)*",
    "- Size of Cells per Dimension: [0-9e+.-]+(, [0-9e+-.]+)*",
    "- Number of Cells:",
    "\\s+- total: \\d+",
    "\\s+- non-empty: \\d+ \\([0-9e+-.]+%\\)",
    "\\s+- empty: \\d+ \\([0-9e+-.]+%\\)",
    "- Average Number of Observations per Cell:",
    "\\s+- total: [0-9e+-.]+",
    "\\s+- non-empty: [0-9e+-.]+",
    sep="\\r?\\n")
  )
})

test_that("FeatureObject Output with cellmapping and dim >= 5", {
  init = matrix(1:10, ncol = 6L, nrow = 10L)
  colnames(init) = c("a1", "a2", "a3", "a4", "a5", "a6")
  feat.object = createFeatureObject(init, objective = "a6", blocks = 4L)
  expect_output(print(feat.object), regexp=paste(
      "- Number of Cells per Dimension: \\d+(, \\d+)*, ...",
      "- Size of Cells per Dimension: [0-9e+.-]+(, [0-9e+-.]+)*, ...",
      sep="\\r?\\n")
  )
})
