% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daycount-class.R
\name{toyears}
\alias{toyears}
\alias{toyears,Daycount,Term,missing-method}
\alias{toyears,Daycount,character,missing-method}
\alias{toyears,Daycount,numeric,character-method}
\title{Terms in years according to Daycount}
\usage{
toyears(x, t, units)
}
\arguments{
\item{x}{a Daycount object.}

\item{t}{represents the term to compound. Can be a numeric, a \code{Term},
or a character representing a \code{Term}. See Details.}

\item{units}{a character with the Term units. Can also be missing.
See Details.}
}
\value{
A numeric with the value of the given \code{Term} in years.
}
\description{
\code{toyears} returns a numeric representing a Term in years.
}
\details{
\code{toyears} returns the given term in years, since we are assuming
annual rates.
The \code{t} argument can be a term instance, a string defining a term
or a numeric.
In the last alternative, the \code{units} argument must be
provided with a valid Term units (days, months, years).
}
\examples{
dc <- daycount("actual/360")
toyears(dc, 10, "days")
t <- term(10, "months")
toyears(dc, t)
}
