% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotrate-class.R
\name{spotrate-compare-method}
\alias{spotrate-compare-method}
\alias{Compare,SpotRate,SpotRate-method}
\alias{Compare,SpotRate,numeric-method}
\alias{Compare,numeric,SpotRate-method}
\title{SpotRate comparison operations}
\usage{
\S4method{Compare}{SpotRate,SpotRate}(e1, e2)

\S4method{Compare}{SpotRate,numeric}(e1, e2)

\S4method{Compare}{numeric,SpotRate}(e1, e2)
}
\arguments{
\item{e1}{a \code{SpotRate} object or a numeric}

\item{e2}{a \code{SpotRate} object or a numeric}
}
\value{
A boolean \code{logical} object.
The comparison with \code{SpotRate} objects only takes all fields
into account.
Comparing \code{SpotRate} against numeric values is equivalent to
coerce the \code{SpotRate} object to numeric execute the operation,
this is a syntax sugar for a shortcut that is commonly applied.
}
\description{
Comparison operations with SpotRate class
\code{SpotRate} objects can be compared among themselves or with numeric
variables.
}
\examples{

spr <- as.spotrate("0.06 simple actual/365 actual")
spr == 0.06
}
