% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{state_of_the_state}
\alias{state_of_the_state}
\alias{state_index}
\alias{state_words}
\title{What America’s Governors Are Talking About}
\format{
2 data frames about the 50 U.S Governors' Speeches

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 2223 rows and 9 columns.
}
\source{
The chi-square test statistic \url{https://scikit-learn.org/stable/modules/generated/sklearn.feature_selection.chi2.html#sklearn.feature_selection.chi2}
}
\usage{
state_index

state_words
}
\description{
The raw data behind the story
"What America’s Governors Are Talking About"
\url{https://fivethirtyeight.com/features/what-americas-governors-are-talking-about/}
}
\section{state_index}{

A data frame with 50 rows representing the 50 U.S. states and 5 variables:
\describe{
  \item{state}{the state}
  \item{governor}{the name of the state's governor}
  \item{party}{the party of the state's governor}
  \item{filename}{the filename of the speech in the speeches folder at \url{https://github.com/rudeboybert/fivethirtyeight/tree/master/data-raw/state-of-the-state/speeches}}
  \item{url}{a link to an official/media source for the speech}
  }
}

\section{state_words}{

A data frame with 2,223 rows representing phrases and 9 variables:
\describe{
  \item{phrase}{one-, two-, and three-word phrases spoken repeatedly}
  \item{category}{thematic categories for the phrases}
  \item{d_speeches}{number of Democratic speeches containing the phrase}
  \item{r_speeches}{number of Republican speeches containing the phrase}
  \item{total}{total number of speeches containing the phrase}
  \item{percent_of_d_speeches}{percent of the 23 Democratic speeches containing the phrase}
  \item{percent_of_r_speeches}{percent of the 27 Republican speeches containing the phrase}
  \item{chi2}{the chi-square test statistic for statistical significance}
  \item{pval}{p-value for chi^2 test}
  }
}

\keyword{datasets}
