% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_jen.R
\docType{data}
\name{police_locals}
\alias{police_locals}
\title{Most Police Don't Live In The Cities They Serve}
\format{A data frame with 75 rows representing cities and 8 variables:
\describe{
  \item{city}{U.S. city}
  \item{force_size}{Number of police officers serving that city}
  \item{all}{Percentage of the total police force that lives in the city}
  \item{white}{Percentage of white (non-Hispanic) police officers who live in the city}
  \item{non_white}{Percentage of non-white police officers who live in the city}
  \item{black}{Percentage of black police officers who live in the city}
  \item{hispanic}{Percentage of Hispanic police officers who live in the city}
  \item{asian}{Percentage of Asian police officers who live in the city}
}}
\source{
See \url{https://github.com/fivethirtyeight/data/tree/master/police-locals}
}
\usage{
police_locals
}
\description{
The raw data behind the story
"Most Police Don't Live In The Cities They Serve"
\url{https://fivethirtyeight.com/features/most-police-dont-live-in-the-cities-they-serve/}.
}
\details{
The dataset includes the cities with the 75 largest police forces, with the exception of Honolulu for which data is not available. All calculations are based on data from the U.S. Census.

The Census Bureau numbers are potentially going to differ from other counts for three reasons:
\enumerate{
   \item The census category for police officers also includes sheriffs, transit police and others who might not be under the same jurisdiction as a city's police department proper. The census category won't include private security officers.
   \item The census data is estimated from 2006 to 2010; police forces may have changed in size since then.
   \item There is always a margin of error in census numbers; they are estimates, not complete counts.
}

Note: Missing values means that there are fewer than 100 police officers of that race serving that city.
}
\examples{
# To convert data frame to tidy data (long) format, run:
library(dplyr)
library(tidyr)
police_locals_tidy <- police_locals \%>\%
   gather(key = "race", value = "perc_in", all:asian)
}
\keyword{datasets}
