% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_dist.R
\name{build_dist}
\alias{build_dist}
\title{Build Distribution Functions}
\usage{
build_dist(x, family)
}
\arguments{
\item{x}{numeric vector}

\item{family}{distribution family character name}
}
\value{
list of family functions for d, p, q, r, and parameters
}
\description{
A wrapper for building function families given
a numeric vector and the distribution family
}
\examples{
fittedDists <- build_dist(rpois(100,5), 'pois')
dpois(x = 5, lambda = 5)
fittedDists$dpois(5)
ppois(5, 5)
fittedDists$ppois(5)
qpois(.5, 5)
fittedDists$qpois(.5)
set.seed(8257)
rpois(100, 5)
set.seed(8257)
fittedDists$rpois(100)
fittedDists$parameters
}
