% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_empirical.R
\name{fit_empirical}
\alias{fit_empirical}
\title{Fit Empirical Distribution}
\usage{
fit_empirical(x)
}
\arguments{
\item{x}{integer or double vector}
}
\value{
if integer vector then list of family functions for d, p, q, r, and parameters
based on each integer value. if it is a double vector then
list of family functions for d, p, q, r, and parameters based on
Freedman-Diaconis rule for optimal number of histogram bins.
}
\description{
Fit Empirical Distribution
}
\examples{
set.seed(562)
x <- rpois(100, 5)
empDis <- fit_empirical_discrete(x)
empDis$dempDis(1)
empDis$pempDis(2)
empDis$qempDis(1)
empDis$r(10000)
empDis$parameters

set.seed(562)
}
