% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMultiBin.R
\name{dLMBin}
\alias{dLMBin}
\title{Lovinson Multiplicative  Binomial Distribution}
\usage{
dLMBin(x,n,p,phi)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{n}{single value for no of binomial trials.}

\item{p}{single value for probability of success.}

\item{phi}{single value for phi.}
}
\value{
The output of \code{dLMBin} gives a list format consisting

\code{pdf}         probability function values in vector form.

\code{mean}        mean of Lovinson Multiplicative Binomial Distribution.

\code{var}        variance of Lovinson Multiplicative Binomial Distribution.
}
\description{
These functions provide the ability for generating probability function values and
cumulative probability function values for the Lovinson Multiplicative Binomial Distribution.
}
\details{
The probability function and cumulative function can be constructed and are denoted below

The cumulative probability function is the summation of probability function values.

\deqn{P_{LMBin}(x)= {n \choose x} p^x (1-p)^{n-x} \frac{(phi^{x(n-x)}}{f(p,phi,n)} }

here \eqn{f(p,phi,n)} is
\deqn{f(p,phi,n)= \sum_{k=0}^{n} {n \choose k} p^k (1-p)^{n-k} (phi^{k(n-k)} )}

\deqn{x = 0,1,2,3,...n}
\deqn{n = 1,2,3,...}
\deqn{k = 0,1,2,...,n}
\deqn{0 < p < 1}
\deqn{0 < phi }

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
col <- rainbow(5)
a <- c(0.58,0.59,0.6,0.61,0.62)
b <- c(0.022,0.023,0.024,0.025,0.026)
plot(0,0,main="Lovinson Multiplicative binomial probability
     function graph",xlab="Binomial random variable",
     ylab="Probability function values",xlim = c(0,10),ylim = c(0,0.5))
for (i in 1:5)
{
lines(0:10,dLMBin(0:10,10,a[i],1+b[i])$pdf,col = col[i],lwd=2.85)
points(0:10,dLMBin(0:10,10,a[i],1+b[i])$pdf,col = col[i],pch=16)
}

dLMBin(0:10,10,.58,10.022)$pdf   #extracting the pdf values
dLMBin(0:10,10,.58,10.022)$mean   #extracting the mean
dLMBin(0:10,10,.58,10.022)$var   #extracting the variance


#plotting random variables and cumulative probability values
col <- rainbow(5)
a <- c(0.58,0.59,0.6,0.61,0.62)
b <- c(0.022,0.023,0.024,0.025,0.026)
plot(0,0,main="Lovinson Multiplicative binomial probability
     function graph",xlab="Binomial random variable",
     ylab="Probability function values",xlim = c(0,10),ylim = c(0,1))
for (i in 1:5)
{
lines(0:10,pLMBin(0:10,10,a[i],1+b[i]),col = col[i],lwd=2.85)
points(0:10,pLMBin(0:10,10,a[i],1+b[i]),col = col[i],pch=16)
}

pLMBin(0:10,10,.58,10.022)     #acquiring the cumulative probability values

}
\references{
\insertRef{elamir2013multiplicative}{fitODBOD}
}
