% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddBin.R
\name{EstMLEAddBin}
\alias{EstMLEAddBin}
\title{Estimating the probability of success and alpha for Additive Binomial
Distributon}
\usage{
EstMLEAddBin(x,freq)
}
\arguments{
\item{x}{vector of binomial random variables}

\item{freq}{vector of frequencies}
}
\value{
The output of \code{EstMLEAddBin} will produce a list consisting

\code{p} probability of success

\code{alpha} alpha
}
\description{
The function will estimate the probability of success and alpha using the maximum log likelihood method
for the Additive Binomial distribution when the binomial random
variables and corresponding frequencies are given
}
\details{
\deqn{freq \ge 0}
\deqn{x = 0,1,2,..}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further
}
\examples{
No.D.D=0:7         #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)     #assigning the corresponding frequencies
#estimating the probability value and alpha value
\dontrun{
suppressWarnings(EstMLEAddBin(No.D.D,Obs.fre.1))

#extracting the estimated probability value
suppressWarnings(EstMLEAddBin(No.D.D,Obs.fre.1)$p)
}
}
\references{
Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate discrete distributions (Vol. 444).
Hoboken, NJ: Wiley-Interscience.

L. L. Kupper, J.K.H., 1978. The Use of a Correlated Binomial Model for the Analysis of Certain Toxicological
Experiments. Biometrics, 34(1), pp.69-76.

Available at: \url{http://www.jstor.org/stable/2529589} .

Paul, S.R., 1985. A three-parameter generalization of the binomial distribution. Communications in Statistics
- Theory and Methods, 14(6), pp.1497-1506.

Available at: \url{http://www.tandfonline.com/doi/abs/10.1080/03610928508828990} .

Jorge G. Morel and Nagaraj K. Neerchal. Overdispersion Models in SAS. SAS Institute, 2012.
}
