% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistep_xgboost.R
\name{xgboost_multistep_fit_impl}
\alias{xgboost_multistep_fit_impl}
\title{Bridge XGBOOST Multistep Modeling function}
\usage{
xgboost_multistep_fit_impl(
  x,
  y,
  max_depth = 6,
  nrounds = 15,
  eta = 0.3,
  colsample_bytree = NULL,
  colsample_bynode = NULL,
  min_child_weight = 1,
  gamma = 0,
  subsample = 1,
  validation = 0,
  early_stop = NULL,
  lag_periods = NULL,
  external_regressors = NULL,
  forecast_horizon = NULL,
  selected_features = NULL,
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{max_depth}{An integer for the maximum depth of the tree.}

\item{nrounds}{An integer for the number of boosting iterations.}

\item{eta}{A numeric value between zero and one to control the learning rate.}

\item{colsample_bytree}{Subsampling proportion of columns.}

\item{colsample_bynode}{Subsampling proportion of columns for each node
within each tree. See the \code{counts} argument below. The default uses all
columns.}

\item{min_child_weight}{A numeric value for the minimum sum of instance
weights needed in a child to continue to split.}

\item{gamma}{A number for the minimum loss reduction required to make a
further partition on a leaf node of the tree}

\item{subsample}{Subsampling proportion of rows.}

\item{validation}{A positive number. If on \verb{[0, 1)} the value, \code{validation}
is a random proportion of data in \code{x} and \code{y} that are used for performance
assessment and potential early stopping. If 1 or greater, it is the \emph{number}
of training set samples use for these purposes.}

\item{early_stop}{An integer or \code{NULL}. If not \code{NULL}, it is the number of
training iterations without improvement before stopping. If \code{validation} is
used, performance is base on the validation set; otherwise the training set
is used.}

\item{lag_periods}{lag periods}

\item{external_regressors}{external regressors}

\item{forecast_horizon}{forecast horizon}

\item{selected_features}{selected features}

\item{...}{Additional arguments passed to \code{xgboost::xgb.train}}
}
\description{
Bridge XGBOOST Multistep Modeling function
}
\keyword{internal}
