% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profiles.R
\name{profiles}
\alias{profiles}
\title{Live profiles}
\usage{
profiles(ProfileID = NULL, ProfileName = NULL, path)
}
\arguments{
\item{ProfileID}{Numeric vector, id of profiles of interest}

\item{ProfileName}{Character vector, full name of profile(s)}

\item{path}{String; Fingertips API address. Function will default to the
correct address}
}
\value{
A data frame of live profile ids and names along with their domain
  names and ids.
}
\description{
Outputs a data frame of live profiles that data are available for in
Fingertips \url{http://fingertips.phe.org.uk/}
}
\examples{
\dontrun{
# Returns a complete data frame of domains and their profiles
profiles()}

# Returns a data frame of all of the domains in the Public Health Outcomes Framework
profiles(ProfileName = "Public Health Outcomes Framework")
}
\seealso{
\code{\link{area_types}} for area type  and their parent mappings,
  \code{\link{indicators}} for indicator lookups,
  \code{\link{indicator_metadata}} for indicator metadata and
  \code{\link{deprivation_decile}} for deprivation decile lookups and
  \code{\link{category_types}} for category lookups and
  \code{\link{indicator_areatypes}} for indicators by area types lookups and
  \code{\link{indicators_unique}} for unique indicatorids and their names

Other lookup functions: \code{\link{area_types}},
  \code{\link{category_types}},
  \code{\link{deprivation_decile}},
  \code{\link{indicator_areatypes}},
  \code{\link{indicator_metadata}},
  \code{\link{indicators_unique}}, \code{\link{indicators}}
}
