% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{as.data.frame.finbif_records}
\alias{as.data.frame.finbif_records}
\alias{as.data.frame.finbif_records_list}
\title{Coerce a \verb{finbif_records*} object to a \code{data.frame}}
\usage{
\method{as.data.frame}{finbif_records}(x, ..., locale = getOption("finbif_locale"))

\method{as.data.frame}{finbif_records_list}(x, ..., locale = getOption("finbif_locale"), quiet = TRUE)
}
\arguments{
\item{x}{A \verb{finbif_records*} object.}

\item{...}{Additional arguments. Not used.}

\item{locale}{Character. A locale to use for columns with localised data.}

\item{quiet}{Logical. If \code{TRUE} (default) suppress progress indicator of
conversion.}
}
\value{
A \code{data.frame}.
}
\description{
Converts the result of a FinBIF query to a \code{data.frame}. The function
\code{finbif_records()} and its associated classes and methods have been
deprecated and user access will be removed in the next release of the finbif
package.
}
\examples{
\dontrun{

# Download the latest records from FinBIF
# and convert to a `data.frame`
resp <- finbif_records()
df <- as.data.frame(resp)

}
}
