% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_column_totals.R
\name{ff_row_totals}
\alias{ff_row_totals}
\alias{finalfit_row_totals}
\title{Add row totals to \code{summary_factorlist()} output}
\usage{
ff_row_totals(
  df.in,
  .data,
  dependent,
  explanatory,
  missing_column = TRUE,
  percent = TRUE,
  digits = 1,
  na_include_dependent = FALSE,
  na_complete_cases = FALSE,
  total_name = "Total N",
  na_name = "Missing N"
)

finalfit_row_totals(
  df.in,
  .data,
  dependent,
  explanatory,
  missing_column = TRUE,
  percent = TRUE,
  digits = 1,
  na_include_dependent = FALSE,
  na_complete_cases = FALSE,
  total_name = "Total N",
  na_name = "Missing N"
)
}
\arguments{
\item{df.in}{\code{summary_factorlist()} output.}

\item{.data}{Data frame used to create \code{summary_factorlist()}.}

\item{dependent}{Character. Name of dependent variable.}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}

\item{missing_column}{Logical. Include a column of counts of missing data.}

\item{percent}{Logical. Include percentage.}

\item{digits}{Integer length 1. Number of digits for percentage.}

\item{na_include_dependent}{Logical. When TRUE, missing data in the dependent
variable is included in totals.}

\item{na_complete_cases}{Logical. When TRUE, missing data counts for variables
are for compelte cases across all included variables.}

\item{total_name}{Character. Name of total column.}

\item{na_name}{Character. Name of missing column.}
}
\value{
Data frame.
}
\description{
This adds a total and missing count to variables. This is useful for
continuous variables. Compare this to \code{summary_factorlist(total_col =
TRUE)} which includes a count for each dummy variable as a factor and mean
(sd) or median (iqr) for continuous variables.
}
\examples{
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = 'mort_5yr'
colon_s \%>\%
 summary_factorlist(dependent, explanatory) \%>\%
	ff_row_totals(colon_s, dependent, explanatory)
}
