% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tagged_fish.R
\name{get_tagged_fish}
\alias{get_tagged_fish}
\title{Get A Dataframe of All Tagged fish from CalFishTrack}
\usage{
get_tagged_fish(important_fields = NULL)
}
\arguments{
\item{important_fields}{a vector of important field indexes to be imported
from the ERDDAP dataset}
}
\value{
A dataframe of fish data which can be joined to detection data
}
\description{
This function searches the California Fish Tracking ERDAPP Database to create
a dataframe of tagged fish data. Desired fields can be set to select only
certain fields. This data is used to add fish data to detection data in the
add_fish function.
}
\examples{
# Retrieve only a few important fields (fish type, tag code, release date)
tout <- getOption("timeout")
options(timeout = 4)
fields <- c(7,8,16)
try(cal_fish_lite <- get_tagged_fish(important_fields = fields))
options(timeout = tout)
}
