% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_SVT.R
\name{fill.SVT}
\alias{fill.SVT}
\title{Singular Value Thresholding for Nuclear Norm Optimization}
\usage{
fill.SVT(A, lambda = 1, maxiter = 100, tol = 0.001)
}
\arguments{
\item{A}{an \eqn{(n\times p)} partially observed matrix.}

\item{lambda}{a regularization parameter.}

\item{maxiter}{maximum number of iterations to be performed.}

\item{tol}{stopping criterion for an incremental progress.}
}
\value{
a named list containing \describe{
\item{X}{an \eqn{(n\times p)} matrix after completion.}
}
}
\description{
\code{fill.SVT} is an iterative updating scheme for Nuclear Norm Minimization problem. An unconstrained
parahrase of the problem introduced in \code{\link{fill.nuclear}} is
\deqn{\mathrm{minimize}\quad \frac{1}{2}\|P_{\Omega}(X-A) \|_F^2 + \lambda \| X \|_*}
where \eqn{P_{\Omega}(X)=X_{ij}} if it is observed, or \eqn{0} otherwise.
It performs iterative shrinkage on newly computed singular values.
}
\examples{
## load image data of 'lena128'
data(lena128)

## transform 5\% of entries into missing
A <- aux.rndmissing(lena128, x=0.05)

## apply the method
fill1 <- fill.SVT(A, lambda=0.1)
fill2 <- fill.SVT(A, lambda=1.0)
fill3 <- fill.SVT(A, lambda=10)

## visualize
par(mfrow=c(2,2), pty="s")
image(A, col=gray((0:100)/100), axes=FALSE, main="5\% missing")
image(fill1$X, col=gray((0:100)/100), axes=FALSE, main="lbd=0.1")
image(fill2$X, col=gray((0:100)/100), axes=FALSE, main="lbd=1")
image(fill3$X, col=gray((0:100)/100), axes=FALSE, main="lbd=10")

}
\references{
\insertRef{cai_singular_2010}{filling}
}
\seealso{
\code{\link{fill.nuclear}}
}
