% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{forest.plot}
\alias{forest.plot}
\title{forest.plot}
\usage{
forest.plot(
  parent.df,
  y.rank.col = "rank",
  Point.Est = "hr",
  lower.lim = "low",
  upper.lim = "high",
  y.label.rank.col = "rank",
  y.label.col = "subcategory",
  x.label = "Estimate",
  y.label = "Item",
  log.trans = TRUE,
  x.limits = c(0.21, 5),
  x.ticks = 2^(-2:2),
  y.limits = NULL,
  category.color = "category",
  background.palette = c("red", "blue"),
  category.palette = c("red", "blue"),
  shape.palette = c(16, 16),
  flip.palette = FALSE
)
}
\arguments{
\item{parent.df}{data.frame used by ggplot}

\item{y.rank.col}{column holding ranks for line items in forest/dot/table plots}

\item{Point.Est}{point estimate}

\item{lower.lim}{column holding lower limit of CI}

\item{upper.lim}{column holding upper limit of CI (forest.plot)}

\item{y.label.rank.col}{column holding ranks for labels in forest/dot/table plots}

\item{y.label.col}{column holding labels for forest/dot/table plots}

\item{x.label}{value gets passed to labs}

\item{y.label}{value gets passed to labs}

\item{log.trans}{Logical; if TRUE log transformation is applied to x axis (ensure x.limits are positive!) (forest.plot)}

\item{x.limits}{value gets passed to scale_x_continuous}

\item{x.ticks}{value gets passed to scale_x_continuous}

\item{y.limits}{passed to scale_y_continuous}

\item{category.color}{data.frame column assocated with aes color mapping (forest.plot, line.plot, nsubj.plot, table.plot)}

\item{background.palette}{palette gets passed to scale_fill_manual (forest.plot)}

\item{category.palette}{colors assoicated with categorical variable}

\item{shape.palette}{values passed to scale_shape_manual}

\item{flip.palette}{logical; if TRUE it reverse the order of colors used for background (forest.plot)}
}
\value{
A ggplot object is returned.
}
\description{
A function for creating harmonized forest.plots via ggplot2 offering compatiability with table.plot and dot.plot.
}
\author{
Greg Cicconetti
}
