% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excelMatch.R
\name{excelMatch}
\alias{excelMatch}
\title{Obtain column number or variable name from Excel named Columns}
\usage{
excelMatch(..., n = NULL, names = NULL)
}
\arguments{
\item{...}{An Excel-like string consisting of all capital letters (e.g., "AAQ", "BZ", "RQ", "S", etc.)}

\item{n}{the number of columns of the data of interest}

\item{names}{the column names of the data of interest}
}
\value{
either a variable name or column number
}
\description{
Obtain column number or variable name from Excel named Columns
}
\details{
Excel columns are labeled with letters (e.g., A, B, C, ... AA, AB, AC, etc). This function
accepts a string (e.g., "AAC") and returns either a number that indicates where that string falls
in the sequence of excel named columns, or it returns the variable name corresponding to that column number.
}
\examples{
fake.names = paste("Variable", 1:1000, sep="")
# find the Variable name corresponding to AC
excelMatch("AC", names=fake.names)
# find the column number instead
excelMatch("AC", n=1000)
}
\author{
Dustin Fife
}
\seealso{
\code{\link{excelCols}}
}

